/*
  selects the right/left channel in a stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "bpmDevice.h"





BPMDevice::BPMDevice(char* name):AudioBufferDelayStreamProducer(name){
  this->name=name;
  bpmFilter=new BPMFilter();

}


BPMDevice::~BPMDevice() {

  delete bpmFilter;
}


char* BPMDevice::getNodeName() {
  return "BPMDevice";
}


/**
  This method is called by the GUI frontend.
  It sets the BPM we dont want to hear
*/
void BPMDevice::setBPM(int bpm) {
  bpmFilter->setBPM(bpm);
}



/** 
   The method writeIn(...)is entered by a seperate thread.
   <p>
   Here you can directly modify the PCM stream!     
   <pre> 
   NodeDevice* source       the parent Device which calls this method
   DeviceConfig* buf        class which stores the various
                            information asociated with a PCM stream 
                            (eg: stereo,samplesize,name of song, etc...)
   </pre>
*/
void BPMDevice::writeIn(NodeDevice* source,DeviceConfig* config) {



  bpmFilter->transform(config);


  // now insert the new buffer
  AudioStream* audioStream=config->getAudioStream();
  AudioBuffer* audioBuffer=audioStream->getAudioBuffer();
  MemChunk* oldChunk=audioBuffer->getMemChunk();
  audioBuffer->setMemChunk(bpmFilter->getMemChunk());
  
  AudioBufferDelayStreamProducer::writeIn(source,config);

  audioBuffer->setMemChunk(oldChunk);
  

}


