/*
  This jumps in the stream. 
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */







#ifndef __GUIJUMPDEVICE_H
#define __GUIJUMPDEVICE_H


/**
   This is a gui element which allows to seek in the
   stream. It works very simple. It monitors the statusEvent
   by the stream. If the stream stops the device is inactive.
   If the stream plays it monitors the timeevent.
   If the user press on the slider it stops monitoring
   the timeevent.
   If he relase the button it sends the jump order to the producer.
*/

#include <qslider.h>
#include <qpainter.h>
#include <qpushbt.h>
#include <qlayout.h>

#include <devices/genericPlayer.h>
#include <devices/audioStreamInfoDevice.h>
#include <yafcore/buffer.h>

#include <guiDevice.h>





class GuiJumpDevice : public GuiDevice {
  Q_OBJECT

  AudioStreamInfoDevice* audioStreamInfoDevice;

  int jumps;
  int len;

  int updateSlider;
  int status;
  int sliderWidth;
  int lProcessEvents;

 public:
  GuiJumpDevice(QWidget *parent=0, const char *name=0);
  ~GuiJumpDevice();
  void attachTo(AudioStreamInfoDevice* audioStreamInfoDevice);
  void detach();

  virtual void buildGui();

  QSize sizeHint() const;
 public slots:
   void sliderPressed(); 
   void sliderReleased();

 signals:
   void jump(int seconds);
 
 protected:
  void processEvent(char eventId);
  QSlider *sb;


};


#endif
