/*
  a GUI for a spectrum analyser
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef _GUISPECTRUMANALYSER_H
#define _GUISPECTRUMANALYSER_H

#include <iostream.h>
#include <kapp.h>
#include <qpainter.h>
#include <qtimer.h> 
#include <qpixmap.h> 


#include <spectrumAnalyserDeviceConfig.h>
#include <devices/spectrumAnalyserDevice.h>
#include <spectrumImage.h>
#include <guiDevice.h>
#include <math.h>


class GuiSpectrumAnalyser : public GuiDevice {
  Q_OBJECT

 public:
  GuiSpectrumAnalyser( QWidget *parent=0, const char *name=0);
  ~GuiSpectrumAnalyser();
  void attachTo(SpectrumAnalyserDevice* spectrumAnalyserDevice);
  void detach();

  QSize sizeHint() const;
  void mousePressEvent ( QMouseEvent* mouseEvent);
  void paintEvent ( QPaintEvent * paintEvent );

 public slots:
   void configure();
   void applyEvent();

 private slots:
    void doUpdate();


 protected:
  void processEvent(char eventId);


 private:
  SpectrumImage* spectrumImage;
  SpectrumAnalyserDevice* spectrumAnalyserDevice;
  QPixmap* pixMap;
  float* currentPeaks;
  int width;
  int height;
  int bands;
  int spaHeight;
  QTimer* updateTimer;
  SpectrumAnalyserDeviceConfig* spectrumAnalyserDeviceConfig;
};
#endif

