/*
  gui part for the status device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __GUISTATUSDEVICE_H
#define __GUISTATUSDEVICE_H

#include <qpainter.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qslider.h>


#include <devices/audioStreamInfoDevice.h>
#include <yafcore/buffer.h>

#include <guiDevice.h>





class GuiStatusDevice : public GuiDevice {
  Q_OBJECT

  AudioStreamInfoDevice* audioStreamInfoDevice;
  int eventMask;

 public:
  GuiStatusDevice( QWidget *parent=0, const char *name=0 );
  ~GuiStatusDevice();
  void attachTo(AudioStreamInfoDevice* audioStreamInfoDevice);
  void detach();


  int getStatus();

  QSize sizeHint() const;
  void paintEvent (QPaintEvent * paintEvent);

 protected:
  void processEvent(char eventId);

};


#endif
