/*
  nice bits per second widget for kdeSkin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <bpsWidget.h>


#define FONT     "helvetica"
#define FONTSIZE 10
#define BGCOLOR 0,0,0
#define COLOR3  0,255,0


BPSWidget::BPSWidget( QWidget *parent=0, const char *name=0 ) :
  GuiBPSDevice(parent,name){
  text=new char[10];
  connect(this, SIGNAL(setSongEvent()),this,SLOT(setSongEvent()));
}


BPSWidget::~BPSWidget() {
  delete text;
}


QSize BPSWidget::sizeHint() const {
  return QSize(50,10);
}


void BPSWidget::setSongEvent() {
  repaint(false);
}


void BPSWidget::paintEvent ( QPaintEvent * paintEvent ) {
  int w=width();
  int h=height();

  int bps=getBPS();
  snprintf(text,10,"%dkBits/s",bps);

  QFont font( FONT, FONTSIZE );
  QFontMetrics fontMetrics( font );
  QPainter paint;
  paint.begin( this );
  paint.setBackgroundColor(QColor(BGCOLOR));
  paint.eraseRect(0,0,w,h);
  paint.setFont(font);
  paint.setPen( QColor(COLOR3) );
  paint.drawText(0,10,text);
  paint.end();  
}

