/*
  a nicer widget for the musicInfo.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <infoWidget.h>




InfoWidget::InfoWidget( QWidget *parent=0, const char *name=0 ):
              GuiInfoDevice( parent, name ) {

  defaultWidth=250;
  completePixmap=new QPixmap(defaultWidth,30);
  completePixmap->fill(QColor(BGCOLOR));

  timer=new QTimer(this);
  connect(timer,SIGNAL(timeout()),this,SLOT(timeEvent()));
  connect(this, SIGNAL(setSongEvent()),this,SLOT(setSongEvent()));
  timer->start(50);
  scrollerSetup();
}


InfoWidget::~InfoWidget() {
  delete completePixmap;
}


void InfoWidget::timeEvent() {
  repaint(false);
}



void InfoWidget::setSongEvent() {

  QFont font(FONT, FONTSIZE);
  QFontMetrics fontMetrics( font );
  int w;
  int h;
  char* infoString=getInfoString();
  setBackgroundColor (QColor(0,0,0));

  w=calculateWidth(infoString);
  h=calculateHeight();
  completePixmap->resize(w,h); 
  completePixmap->fill(QColor(BGCOLOR));

  QPainter paint;
  paint.begin( completePixmap );
  paint.setFont(font);
  paint.setPen( QColor(COLOR3) );
  paint.drawText(0,h,infoString);
  paint.end();  

  scrollerSetup();
  update();

}






int InfoWidget::calculateWidth(char* string) {
  QFont font( FONT, FONTSIZE );
  QFontMetrics fontMetrics( font );
  int back=fontMetrics.width(string);
  if (back < defaultWidth) {
    back=defaultWidth;
  }
  return back;
}


int InfoWidget::calculateHeight() {
  QFont font( FONT, FONTSIZE );
  QFontMetrics fontMetrics( font );
  
  return fontMetrics.height();
}


void InfoWidget::scrollerSetup() {
  xScrollPos=0;
  xScrollDirection=0;
  timer->stop();
 
  if (completePixmap->width() > defaultWidth) {
    xScrollDirection=1;
    timer->start(50);
  }
}


QSize InfoWidget::sizeHint() const {
  QSize size(defaultWidth,15);
  return size;
}


void InfoWidget::paintEvent ( QPaintEvent * paintEvent ) {
  QPainter paint;
  if (completePixmap->width() <= defaultWidth) {
    paint.begin( this );
    paint.drawPixmap(0,0,*completePixmap);
    paint.end();  
    return;
  }

  // pixmap widther than window:
  int xDrawWidth;
  int xRestWidth;

  xDrawWidth=completePixmap->width()-xScrollPos;
  if (xDrawWidth > defaultWidth) {
    xDrawWidth=defaultWidth;
  }
  paint.begin( this );
  paint.drawPixmap(0,0,*completePixmap,xScrollPos,0,xDrawWidth);
  if (xDrawWidth < defaultWidth) {
    xRestWidth=defaultWidth-xDrawWidth;
    paint.drawPixmap(xDrawWidth,0,*completePixmap,0,0,xRestWidth);
  }
  paint.end();  

  xScrollPos+=xScrollDirection;
  if (abs(xScrollPos) >completePixmap->width() ) {
    xScrollPos=0;
  }
}

