/*
  a nicer widget for the musicInfo.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */







#ifndef __INFOWIDGET_H
#define __INFOWIDGET_H

#include <qpixmap.h> 
#include <guiInfoDevice.h>
#include <qtimer.h>



/**
   This widget show how you can add your own look and feel.
   Simple overwrite the paint method.

*/


#define FONT     "helvetica"
#define FONTSIZE 10
#define BGCOLOR 0,0,0
#define COLOR3  255,255,0


class InfoWidget : public GuiInfoDevice {
 Q_OBJECT
  
  QPixmap* completePixmap;
  int xScrollPos;
  int xScrollDirection;

 public:
   InfoWidget( QWidget *parent=0, const char *name=0 );
  ~InfoWidget();

  QSize sizeHint() const;
  void paintEvent ( QPaintEvent * paintEvent );

 public slots:
  void timeEvent();
  void setSongEvent();

 private:
   int calculateWidth(char* string);
   int calculateHeight();
   void scrollerSetup();

   int defaultWidth;
   QTimer* timer;

};
#endif
