/*
  a nicer widget for the status.The default yaf widget is (supposed) ugly
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#include "statusWidget.h"



StatusWidget::StatusWidget( QWidget *parent=0, const char *name=0 ):
              GuiStatusDevice( parent, name ) {

  led=new LED();
  setBackgroundColor(QColor(0,0,0));
}


StatusWidget::~StatusWidget() {
  delete led;
}


QSize StatusWidget::sizeHint() const {
  int w;
  int h;
  QPixmap* pixmap=led->getPixmap(_LED_DIGIT_8);
  w=pixmap->size().width();
  h=pixmap->size().height();
  QSize size(w,h);
  return size;
}


void StatusWidget::paintEvent ( QPaintEvent * paintEvent ) {
  QPixmap* pixmapCurrent;
  int status;

  status=getStatus();
  pixmapCurrent=led->getPixmap(_LED_BLANK);   // default pixmap
  
  if (status == _STATUS_PLAYING) {
    pixmapCurrent=led->getPixmap(_LED_PLAY);
  }
  if (status == _STATUS_PAUSED) {
    pixmapCurrent=led->getPixmap(_LED_PAUSE);
  }
  if (status == _STATUS_STOPPED) {
    pixmapCurrent=led->getPixmap(_LED_STOP);
  }
  
  QPainter paint;
  paint.begin( this );
  paint.drawPixmap ( 0, 0, *pixmapCurrent);
  paint.end();  
  

}


 
