/*
  jumpslider for winamp skins
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <waVolumeSlider.h>


WaVolumeSlider::WaVolumeSlider(WaSkinModell* waSkinModell,
			       QWidget *parent=0, const char *name=0) :
  GuiVolumeDevice(parent,name) {

  this->waSkinModell=waSkinModell;
 WaSkinDesc* waSkinDesc=waSkinModell->getWaSkinMapDesc(_WA_MAPPING_VOLUME_BAR);
  setGeometry((*waSkinDesc->getGeometry()));
}


WaVolumeSlider::~WaVolumeSlider() {
}


void WaVolumeSlider::buildGui() {
  WaSlider* ws = new WaSlider(waSkinModell,_WA_MAPPING_VOLUME_BAR,
			      _WA_MAPPING_VOLUME_SLIDER,
			      parentWidget());
  ws->setPixmapSliderButtonUp(SIGNAL(event_WA_SKIN_VOLUME_SLIDER_NORM()),
			      _WA_SKIN_VOLUME_SLIDER_NORM);
  ws->setPixmapSliderButtonDown(SIGNAL(event_WA_SKIN_VOLUME_SLIDER_PRES()),
				_WA_SKIN_VOLUME_SLIDER_PRES);
  ws->setPixmapSliderBar(SIGNAL(event_WA_SKIN_VOLUME_BAR()),
			 _WA_SKIN_VOLUME_BAR);

  sb=ws;
  QSize size=sb->sizeHint();
  sb->setFixedSize(size);

  connect(this,SIGNAL(valueChanged(int)),sb,SLOT(setValue(int)));
  connect(sb,SIGNAL(valueChanged(int)),this,SIGNAL(valueChanged(int)));
}

QSize WaVolumeSlider::sizeHint() const {
  return sb->sizeHint();
}

void WaVolumeSlider::paintEvent ( QPaintEvent * paintEvent ) {
  // nothing
}

  


