/*
  system dependend wrapper for access to cdrom (Linux)
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "cdromToc.h"
#include "cdromRawAccess.h"

#include <linux/cdrom.h>


/** 
    here you find an example how to port the access method
    to your system.
*/


int CDRomToc::getStartEnd(int fd,int& startToc,int& endToc) {
  struct cdrom_tochdr tochdr;

  if (ioctl(fd, CDROMREADTOCHDR, &tochdr) == -1) {
    perror("ioctl cdromreadtochdr");
    return false;
  }
  
  startToc=tochdr.cdth_trk0;
  endToc=tochdr.cdth_trk1;
  return true;
}


int CDRomToc::readToc(int fd,int num,int& min,int& sec, int& frame) {
  struct cdrom_tocentry tocent;
  tocent.cdte_track = num;
  tocent.cdte_format = CDROM_MSF;
  if (ioctl(fd, CDROMREADTOCENTRY, &tocent) == -1 ) {
    perror("ioctl cdromreadtocentry");
    return false;
  }
  min=tocent.cdte_addr.msf.minute;
  sec=tocent.cdte_addr.msf.second;
  frame=tocent.cdte_addr.msf.frame;
  return true;
}


int CDRomToc::reatLeadOut(int fd,int& min,int& sec, int& frame) {
  struct cdrom_tocentry tocent;
  tocent.cdte_track = CDROM_LEADOUT;
  tocent.cdte_format = CDROM_MSF;
  if (ioctl(fd, CDROMREADTOCENTRY, &tocent) == -1 ) {
    perror("ioctl cdromreadLeadoutn");
    return false;
  }
  min=tocent.cdte_addr.msf.minute;
  sec=tocent.cdte_addr.msf.second;
  frame=tocent.cdte_addr.msf.frame;
  return true;
}




int CDRomRawAccess::read(int minute,int second, int frame) {


  if (isOpen()==false) {
    cerr << "CDRomRawAccess not open"<<endl;
    return false;
  }

  buf.sync[0]=(char)minute;
  buf.sync[1]=(char)second;
  buf.sync[2]=(char)frame;

  int lInRange=cdromToc->isInRange(minute,second,frame);
  if (lInRange == false) {
    if (minute*60+second+1 > cdromToc->getEndSecond()) {
      leof=true;
    }
    return false;
  }
  

  if (ioctl(cdfile, CDROMREADRAW, &buf) == -1 ) {
    perror("ioctl cdromreadraw");
    cout << "min:"<<minute
         << " sec:"<<second
         << " frame:"<<frame<<endl;
    return false;
  }


  buflen=2324;
  return true;
}

