/*
  class for managing byte positions and associated time positions
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "timeStamp.h"



TimeStamp::TimeStamp() {
  key=0;
  keylen=0;
  avRatioGlobal=0.0;
  audioRatioLocal=0;
  audioPacketNr=0;
  time.tv_sec=0;
  time.tv_usec=0;
  // 1 : positive , -1 : negative
  vorzeichen=1;
  globalPaketNr=0;
  audioPacketNrMinor=0;
  floatTimeStamp=0.0;
  ptsTimeStamp=0.0;
  dtsTimeStamp=0.0;
  endPtsTimeStamp=0.0;
 
}


TimeStamp::~TimeStamp() {
}


void TimeStamp::copyTo(TimeStamp* dest) {
  dest->setKey(key,keylen);
  dest->setTime(&time);
  dest->setAVRatioGlobal(avRatioGlobal);
  dest->setAudioRatioLocal(audioRatioLocal);
  dest->setAudioPacketNr(audioPacketNr);
  dest->setVideoPacketNr(videoPacketNr);
  dest->setGlobalPacketNr(globalPaketNr);
  dest->setAudioPacketNrMinor(audioPacketNrMinor);
  dest->setFloatTimeStamp(floatTimeStamp);
  dest->setPTSTimeStamp(ptsTimeStamp);
  dest->setDTSTimeStamp(dtsTimeStamp);
  dest->setEndPTSTimeStamp(endPtsTimeStamp);

}


long TimeStamp::getKey() {
  return key;
}

int TimeStamp::getKeyLen() {
  return keylen;
}

void TimeStamp::setKey(long key,int len) {
  this->key=key;
  this->keylen=len;
}


void TimeStamp::setTime(struct timeval* newTime) {
  time.tv_sec=newTime->tv_sec;
  time.tv_usec=newTime->tv_usec;
}


void TimeStamp::gettimeofday() {
  ::gettimeofday(&time,NULL);
}


timeval* TimeStamp::getTime() {
  return &time;
}


void TimeStamp::waitForIt() {
  struct timeval waitTime;

  waitTime.tv_sec=time.tv_sec;
  waitTime.tv_usec=time.tv_usec;

  if (vorzeichen == 1) {
    //    cout << "wait:"<<waitTime.tv_sec<<" usec:"<<waitTime.tv_usec<<endl;
    select(0,NULL,NULL,NULL,&waitTime);
  }
    
}

void TimeStamp::addOffset(TimeStamp* stamp) {
  addOffset(stamp->time.tv_sec,stamp->time.tv_usec);
}

void TimeStamp::addOffset(int sec,long usec) {
  time.tv_sec=time.tv_sec+sec;
  time.tv_usec=time.tv_usec+usec;
  if (time.tv_usec > 1000000) {
    time.tv_usec-=1000000;
    time.tv_sec++;
  }
  if (time.tv_usec < 0) {
    time.tv_usec+=1000000;
    time.tv_sec--;   
  }  
}

void TimeStamp::minus(int sec,long usec) {

  time.tv_usec-=usec;
  time.tv_sec-=sec;
  if (time.tv_usec <= 0) {
    time.tv_usec=time.tv_usec+1000000;
    time.tv_sec--;
  }
  if (time.tv_usec >= 1000000) {
    time.tv_usec=time.tv_usec-1000000;
    time.tv_sec++;
  }  

}

void TimeStamp::minus(TimeStamp* stamp,TimeStamp* dest) {
  
  long sec=time.tv_sec;
  long usec=time.tv_usec;

  minus(stamp->time.tv_sec,stamp->time.tv_usec);

  dest->set(time.tv_sec,time.tv_usec);
  if (dest != this) {
    time.tv_sec=sec;
    time.tv_usec=usec;
  }
}


int TimeStamp::lessThan(TimeStamp* stamp) {
  return lessThan(stamp->time.tv_sec,stamp->time.tv_usec);
}


int TimeStamp::lessThan(int sec,long usec) {
  int back=false;
  if (time.tv_sec < sec) {
    back=true;
  } else {
    if (time.tv_sec == sec) {
      if (time.tv_usec < usec) {
	back=true;
      }
    }
  }
  return back;
}
 
void TimeStamp::set(long sec,long usec) {
  time.tv_sec=sec;
  time.tv_usec=usec;
}

float TimeStamp::getAVRatioGlobal() {
  return avRatioGlobal;
}


void TimeStamp::setAVRatioGlobal(float avRatio) {
  this->avRatioGlobal=avRatio;
}



int TimeStamp::getAudioRatioLocal() {
  return audioRatioLocal;
}


void TimeStamp::setAudioRatioLocal(int avRatio) {
  this->audioRatioLocal=avRatio;
}



int TimeStamp::getGlobalPacketNr() {
  return globalPaketNr;
}


void TimeStamp::setGlobalPacketNr(int nr) {
  this->globalPaketNr=nr;
}




void TimeStamp::print(char* name) {
  cout << name
       <<" pts:"<<ptsTimeStamp
       <<" dts:"<<dtsTimeStamp
       <<" pkts:"<<floatTimeStamp
       <<" endpts:"<<endPtsTimeStamp
       <<" avGlobal:"<<avRatioGlobal
       <<" audioLocal:"<<audioRatioLocal
       <<" key:"<<key
       <<" vor:"<<vorzeichen
       <<" sec:"<<time.tv_sec
       <<" usec:"<<time.tv_usec
       <<" videoNr:"<<videoPacketNr
       <<" audioNr:"<<audioPacketNr
       <<" audioMinor:"<<audioPacketNrMinor<<endl;

}



int TimeStamp::getAudioPacketNr() {
  return audioPacketNr;
}


void TimeStamp::setAudioPacketNr(int nr) {
  this->audioPacketNr=nr;
}



int TimeStamp::getVideoPacketNr() {
  return videoPacketNr;
}


void TimeStamp::setVideoPacketNr(int nr) {
  this->videoPacketNr=nr;
}


int TimeStamp::isPositive() {
  return ((time.tv_sec >= 0) && (time.tv_usec >= 0));
}


int TimeStamp::isNegative() {
  if (time.tv_sec < 0) {
    return true;
  }
  if (time.tv_usec < 0) {
    return true;
  }
  return false;
}


double TimeStamp::getFloatTimeStamp() {
  return floatTimeStamp;
}


void TimeStamp::setFloatTimeStamp(double floatTimeStamp) {
  this->floatTimeStamp=floatTimeStamp;
}


double TimeStamp::getPTSTimeStamp() {
  return ptsTimeStamp;
}

double TimeStamp::getDTSTimeStamp() {
  return dtsTimeStamp;
}


void TimeStamp::setDTSTimeStamp(double dtsTimeStamp) {
  this->dtsTimeStamp=dtsTimeStamp;
}

void TimeStamp::setPTSTimeStamp(double ptsTimeStamp) {
  this->ptsTimeStamp=ptsTimeStamp;
}
 

double TimeStamp::getEndPTSTimeStamp() {
  return endPtsTimeStamp;
}


void TimeStamp::setEndPTSTimeStamp(double ptsTimeStamp) {
  this->endPtsTimeStamp=ptsTimeStamp;
}
 
void TimeStamp::addPTSOffset(double val) {
  ptsTimeStamp+=val;
}

int TimeStamp::getAudioPacketNrMinor() {
  return audioPacketNrMinor;
}

void TimeStamp::setAudioPacketNrMinor(int nr) {
  this->audioPacketNrMinor=nr;
}



  








