/*
  reads paket input data
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */

#ifndef __PAKET_H
#define __PAKET_H

#include <netinet/in.h>
#include <stdlib.h>
#include "video.h"
#include "../inputPlugin/inputPlugin.h"

#define _PACKET_SYSLAYER            1
#define _PACKET_NO_SYSLAYER         0
#define _PACKET_UNKNOWN_LAYER      -1

#define FLOAT_0x10000 (double)((unsigned long)1 << 16)


class Packet {

  double floatTimeStamp;
  double ptsTimeStamp;
  double dtsTimeStamp;
  
 public:
  Packet();
  ~Packet();

  // returns true if sync successfull 
  // in synccode you find the found startcode (usefull if you
  // need to re-insert it into the buffer)
  int syncStream(unsigned int& syncCodeFound,InputStream* input);

  // returns 1 if it is a syslayer 0 if non syslayer -1 if unknown
  int getSysLayer();
  void setSysLayer(int sysLayer);


  // ready next startCode and then calls readNextLayer with startcode
  int readNextLayer(unsigned char& packetID,InputStream* input);
  

  // returns number of bytes to read from input
  // in layerType you get the current type of systemlayer stream
  // (Audio or Video)
  int readNextLayer(unsigned int startCode,
		    unsigned char& packetID,InputStream* input);
  double getFloatTimeStamp();
  double getPTSTimeStamp();
  double getDTSTimeStamp();

 private:
  int read_sys(unsigned int startCode,InputStream* input);
  int ReadPackHeader(InputStream* input);
  int ReadSystemHeader(InputStream* input);

  int ReadPacket(unsigned char& packetID,InputStream* input);

  int find_start_code_raw(unsigned int* startCode,InputStream* input);
  int ReadStartCode(unsigned int* startCode,InputStream* input);

  void ReadTimeStamp(unsigned char* inputBuffer,unsigned char* hiBit,
		     unsigned long* low4Bytes);

  int MakeFloatClockTime(unsigned char hiBit, unsigned long low4Bytes,
			 double * floatClockTime);
  
  void ReadSTD(unsigned char* inputBuffer,
	       unsigned char* stdBufferScale,
	       unsigned long* stdBufferSize);

  void ReadRate(unsigned char* inputBuffer,unsigned long* rate);
    
  int readPacketTypeStd(InputStream* input);

  int sys_layer;
};

#endif
