/*
 * main.c --
 *
 * Example program for mpegplay library.
 * Build with : 
  BUILD with:

  g++ -I../../yaf/include -I../.. -o mpgplayer mainMpgPlayer.cpp \
  libmpgplayer.a ../mpegplay/libmpegplay.a ../splay/libsplay.a \
  ../inputPlugin/libinputplugin.a ../outPlugin/liboutplugin.a  \
  ../playerPlugin/libplayerplugin.a ../../yaf/shared/audio/libaudio.a  \
  -L/usr/X11R6/lib  -lX11 -lXext -lpthread


 */

#include "mpgPlugin.h"



int main(int argc, char** argv) {


  if (argc <= 1) {
    printf("Usage:\n\n");
    printf("%s filename\n\n",argv[0]);
    exit(0);
  }

  //
  // The order is important !!!!
  // 1. construct
  // 2. set Output
  // 3. open input
  // 4. set input
  // 
  // you cannot set the input _before_ the output 
  // in fact you can, but this gives you a segfault!
    
  MpgPlugin* plugin=new MpgPlugin();
  OutputStream* out=OutPlugin::createOutputStream(_OUTPUT_LOCAL);
  InputStream* in=InputPlugin::createInputStream(argv[1]);


  // The plugin does not do "open"
  in->open(argv[1]);
  in->seek(1024*1024*330);
  char* buf[1024];
  while(1) {
    in->read((char*)buf,1024);
    FILE* f=fopen("a.mpeg","a+");
    fwrite(buf,1,1024,f);
    fclose(f);
  }

  // watch the order!
  plugin->setOutputPlugin(out);
  plugin->setInputPlugin(in);
  //plugin->seek(1950);



  plugin->play();
  int cnt=0;

  while(plugin->getStreamState() == _STREAM_STATE_NOT_EOF) {
    sleep(3);
  }
  cout << "plugin eof"<<endl;
  plugin->close();

  delete plugin;
  delete in;
  delete out;

}
 
