/*
  description for system stream packets.
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "packetDescription.h"




PacketDescription::PacketDescription() {
  streamTimeStamp=0.0;
  ptsTimeStamp=0.0;
  dtsTimeStamp=0.0;
  data=NULL;
  len=0;
}


PacketDescription::~PacketDescription() {
  if (data != NULL) {
    delete data;
  }
}


double PacketDescription::getStreamTimeStamp() {
  return streamTimeStamp;
}


void PacketDescription::setStreamTimeStamp(double streamTimeStamp) {
  this->streamTimeStamp=streamTimeStamp;
  
}

double PacketDescription::getDTSTimeStamp() {
  return dtsTimeStamp;
}


void PacketDescription::setDTSTimeStamp(double dtsTimeStamp) {
  this->dtsTimeStamp=dtsTimeStamp;
}


double PacketDescription::getPTSTimeStamp() {
  return ptsTimeStamp;
}


void PacketDescription::setPTSTimeStamp(double ptsTimeStamp) {
  this->ptsTimeStamp=ptsTimeStamp;
}


void PacketDescription::setData(char* data) {
  this->data=data;
}

char* PacketDescription::getData() {
  return data;
}

void PacketDescription::setLen(int len) {
  this->len=len;
}


int PacketDescription::getLen() {
  return len;
}


void PacketDescription::copyTo(PacketDescription* dest) {
  dest->setStreamTimeStamp(streamTimeStamp);
  dest->setDTSTimeStamp(dtsTimeStamp);
  dest->setPTSTimeStamp(ptsTimeStamp);
  dest->setData(data);
  dest->setLen(len);
}

void PacketDescription::print(char* msg) {
  cout <<msg
       <<" stream:"<<streamTimeStamp
       <<" dts:"<<dtsTimeStamp
       <<" pts:"<<ptsTimeStamp<<endl;
  printf("this: %p ptr:%p len:%d\n",this,data,len);
}
