/*
  describes a paket oriented audioData, because Im fed up
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include "audioData.h"



AudioData::AudioData() {
  data = new char[_AUDIODATA_MAX_SIZE];
  len=0;
  audioTime=new AudioTime();
  start=new TimeStamp();
  end=new TimeStamp();
  writeStamp=new TimeStamp();
  sampleLen=0;
}


AudioData::~AudioData() {
  delete data;
  delete audioTime;
  delete start;
  delete end;
}
 

void AudioData::copyTo(AudioData* dest) {
  dest->setData(getData(),getLen());
  dest->setAudioTime(getAudioTime());
  dest->setStart(getStart());
  dest->setEnd(getEnd());
  dest->setWrite(getWrite());
  dest->setSampleLen(getSampleLen());
}


void AudioData::setData(char* data,int bytes){
  if (bytes > _AUDIODATA_MAX_SIZE) {
    bytes=_AUDIODATA_MAX_SIZE;
    cout << "AudioData::setData too long. dropping bytes"<<endl;
  }
  memcpy(this->data,data,bytes);
  this->len=bytes;
}


void AudioData::appendData(char* data,int bytes){

  if (len+bytes > _AUDIODATA_MAX_SIZE) {
    bytes=_AUDIODATA_MAX_SIZE-len;
    if (bytes <= 0) {
      return;
    }
  }
  memcpy(this->data+len,data,bytes);
  this->len+=bytes;
}

char* AudioData::getData(){
  return data;
}



int AudioData::getLen(){
  return len;
}


void AudioData::setAudioTime(AudioTime* aTime) {
  aTime->copyTo(audioTime);
}

AudioTime* AudioData::getAudioTime() {
  return audioTime;
}


void AudioData::setStart(TimeStamp* s) {
  s->copyTo(start);
}


TimeStamp* AudioData::getStart() {
  return start;
}

void AudioData::setEnd(TimeStamp* e) {
  e->copyTo(end);
}

  
TimeStamp* AudioData::getEnd() {
  return end;
}

void AudioData::setWrite(TimeStamp* e) {
  e->copyTo(writeStamp);
}


TimeStamp* AudioData::getWrite() {
  return writeStamp;
}

long AudioData::getSampleLen() {
  return sampleLen;
}


void AudioData::setSampleLen(long sampleLen) {
  this->sampleLen=sampleLen;
}


void AudioData::print() {
  cout << "AudioData::print [START]"<<endl;
  start->print("audioData start");
  end->print("audioData end");
  cout << "AudioData::print [END]"<<endl;
}
