/*
  wrapper for MMX calls
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "mmx.h"


#ifndef INTEL
int emms() {
  printf("urgs! emms() never should happen\n");
  exit(0);
}
  
int mm_support() {
  return false;
}

#endif


#ifdef INTEL

/*	Function to test if multimedia instructions are supported...
*/

int mm_support() {
	/* Returns 1 if MMX instructions are supported,
	   3 if Cyrix MMX and Extended MMX instructions are supported
	   5 if AMD MMX and 3DNow! instructions are supported
	   0 if hardware does not support any of these
	*/
  cout << "hello"<<endl;
  int rval = 0;
  
  __asm__ __volatile__ (
			/* See if CPUID instruction is supported ... */
			/* ... Get copies of EFLAGS into eax and ecx */
			"push %%eax\n\t"
			"pushf\n\t"
			"popl %%eax\n\t"
			"movl %%eax, %%ecx\n\t"
			
			/* ... Toggle the ID bit in one copy and store */
			/*     to the EFLAGS reg */
			"xorl $0x200000, %%eax\n\t"
			"push %%eax\n\t"
			"popf\n\t"
			
			/* ... Get the (hopefully modified) EFLAGS */
			"pushf\n\t"
			"popl %%eax\n\t"
			
			/* ... Compare and test result */
			"xorl %%eax, %%ecx\n\t"
			"testl $0x200000, %%ecx\n\t"
			"jz NotSupported1\n\t"		/* Nothing supported */
			
			
			/* Get standard CPUID information, and
			   go to a specific vendor section */
			"movl $0, %%eax\n\t"
			"cpuid\n\t"
			
			/* Check for Intel */
			"cmpl $0x756e6547, %%ebx\n\t"
			"jne TryAMD\n\t"
			"cmpl $0x49656e69, %%edx\n\t"
			"jne TryAMD\n\t"
			"cmpl $0x6c65746e, %%ecx\n"
			"jne TryAMD\n\t"
			"jmp Intel\n\t"
			
			/* Check for AMD */
			"\nTryAMD:\n\t"
			"cmpl $0x68747541, %%ebx\n\t"
			"jne TryCyrix\n\t"
			"cmpl $0x69746e65, %%edx\n\t"
			"jne TryCyrix\n\t"
			"cmpl $0x444d4163, %%ecx\n"
			"jne TryCyrix\n\t"
			"jmp AMD\n\t"
			
			/* Check for Cyrix */
			"\nTryCyrix:\n\t"
			"cmpl $0x69727943, %%ebx\n\t"
			"jne NotSupported2\n\t"
			"cmpl $0x736e4978, %%edx\n\t"
			"jne NotSupported3\n\t"
			"cmpl $0x64616574, %%ecx\n\t"
			"jne NotSupported4\n\t"
			/* Drop through to Cyrix... */
			
			
			/* Cyrix Section */
			/* See if extended CPUID is supported */
			"movl $0x80000000, %%eax\n\t"
			"cpuid\n\t"
			"cmpl $0x80000000, %%eax\n\t"
			"jl MMXtest\n\t"     /* Try standard CPUID instead */
			
			/* Extended CPUID supported,so get extended features */
			"movl $0x80000001, %%eax\n\t"
			"cpuid\n\t"
			"testl $0x00800000, %%eax\n\t"	/* Test for MMX */
			"jz NotSupported5\n\t"		/* MMX not supported */
			"testl $0x01000000, %%eax\n\t"  /*Test for Ext'd MMX */
			"jnz EMMXSupported\n\t"
			"movl $1, %0\n\n\t"		/* MMX Supported */
			"jmp Return\n\n"
			"EMMXSupported:\n\t"
			"movl $3, %0\n\n\t"	/* EMMX and MMX Supported */
			"jmp Return\n\t"
			
			
			/* AMD Section */
			"AMD:\n\t"
			
			/* See if extended CPUID is supported */
			"movl $0x80000000, %%eax\n\t"
			"cpuid\n\t"
			"cmpl $0x80000000, %%eax\n\t"
			"jl MMXtest\n\t"   /* Try standard CPUID instead */
			
			/* Extended CPUID supported,so get extended features */
			"movl $0x80000001, %%eax\n\t"
			"cpuid\n\t"
			"testl $0x00800000, %%edx\n\t"	/* Test for MMX */
			"jz NotSupported6\n\t"		/* MMX not supported */
			"testl $0x80000000, %%edx\n\t"	/* Test for 3DNow! */
			"jnz ThreeDNowSupported\n\t"
			"movl $1, %0\n\n\t"		/* MMX Supported */
			"jmp Return\n\n"
			"ThreeDNowSupported:\n\t"
			"movl $5, %0\n\n\t"	/* 3DNow! and MMX Supported */
			"jmp Return\n\t"
			
			
			/* Intel Section */
			"Intel:\n\t"
			
			/* Check for MMX */
			"MMXtest:\n\t"
			"movl $1, %%eax\n\t"
			"cpuid\n\t"
			"testl $0x00800000, %%edx\n\t"	/* Test for MMX */
			"jz NotSupported7\n\t"		/* MMX Not supported */
			"movl $1, %0\n\n\t"		/* MMX Supported */
			"jmp Return\n\t"
			
			/* Nothing supported */
			"\nNotSupported1:\n\t"
			"#movl $101, %0\n\n\t"
			"\nNotSupported2:\n\t"
			"#movl $102, %0\n\n\t"
			"\nNotSupported3:\n\t"
			"#movl $103, %0\n\n\t"
			"\nNotSupported4:\n\t"
			"#movl $104, %0\n\n\t"
			"\nNotSupported5:\n\t"
			"#movl $105, %0\n\n\t"
			"\nNotSupported6:\n\t"
			"#movl $106, %0\n\n\t"
			"\nNotSupported7:\n\t"
			"#movl $107, %0\n\n\t"
			"movl $0, %0\n\n\t"
			
			"popl %%eax\n\t"
			"Return:\n\t"
			: "=a" (rval)
			: /* no input */
			: "ebx", "ecx", "edx"
			);
  
  /* Return */
  return(rval);
}





#endif
