/*
  stores deviceConfig data in a fifo. (it makes a deep copy  of the data)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __DEVICECONFIGFIFO_H
#define __DEVICECONFIGFIFO_H

#include <deviceConfig/deviceConfig.h>
#include <devices/streamProducer.h>
#include <graph/daisyChain.h>

#define _MAX_FIFO_ENTRIES     10

/**
  If a thread deliver data it should never block. This class
  can store a defined number of deviceConfigs. The user
  of this class must take care that the fifo does not overflow.
  <p>
  If overflowDanger() returns true the fifo can store exactly
  one more entry.
  <p>
  <p>
  You have a few switches. 
  lWaitForSource : <p>
                   canSimultaneousDequeue() returns false
                   until all connected sources have at least
                   on entry in the queue.<p>
		   <p>
  lIgnoreStoppedSources: <p>If a source is stopped canSimultaneousDequeue()
                         returns true if all not-stopped sources
                         has at least one entry in the queue<p>

  Eg.<p>
   <p>
  lWaitForSource=true , lIgnoreStoppedSources=true:
  good for simultaneous mixing. 
  <p>
  lIgnoreStoppedSources=false:
  blocks the whole mixing process if a single sources stops
  <p>
  lWaitForSource=false:
  never blocks the queue. canSimultaneousDequeue() always returns true
  <p>
  lIgnoreStoppedSources=true.
  same as above.
  <p>

  
  removeQueueWhenEmpty(..) Until the queue holds data for a source
                           the queue delivers data. If no data
                           is present the source is removed.
			   (this forces the switch lWaitForSource to false)

*/


class DeviceConfigFifo {

  DeviceConfig* configQueue[_MAX_FIFO_ENTRIES];
  int freePos;

  int lWaitForStoppedSource;
  int lWaitForPausedSource;
  int lDequeued;
  NodeDevice* id;
  StatusInfo* status;

 public:
  DeviceConfigFifo(NodeDevice* id);
  ~DeviceConfigFifo();

  void enqueue(DeviceConfig* config);
  DeviceConfig* dequeue();
  void forwardQueue();

  int getFillgrade();

  int getWaitForStoppedSource();
  void setWaitForStoppedSource(int lWaitForStopped);

  int getWaitForPausedSource();
  void setWaitForPausedSource(int lWaitForPaused);

  int getStatus();
  int getDequeue();
  int overflowDanger();
  void clear();
  NodeDevice* getID();
  void setOverflowDangerLock();
  void removeOverflowDangerLock();
  
  void print();
};
#endif
