/*
  defines the format of an audio stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deviceConfig/info/audioInfo.h>



AudioInfo::AudioInfo(){
  setValid(false);
}


AudioInfo::~AudioInfo() {
}


void AudioInfo::setFormat(int stereo,int samplesize,int speed) {
  setStereo(stereo);
  setSampleSize(samplesize);
  setSpeed(speed);
}


int AudioInfo::getStereo() {
  return stereo;
}


int AudioInfo::getSampleSize() {
  return samplesize;
}


int AudioInfo::getSpeed() {
  return speed;
}

void AudioInfo::setStereo(int stereo) {
  if (this->stereo != stereo) {
    setChange(true);
  }
  this->stereo=stereo;
}


void AudioInfo::setSampleSize(int samplesize) {
  if (this->samplesize != samplesize) {
    setChange(true);
  }
  this->samplesize=samplesize;
}


void AudioInfo::setSpeed(int speed) {
  if (this->speed != speed) {
    setChange(true);
  }
  this->speed=speed;
}


float AudioInfo::calculateTime(int bytes) {
  float time=0.0;
  float tmp1=(float)(samplesize*(stereo+1));
  if (tmp1 > 0) {
    time=8.0*(float)bytes/tmp1;
    if (speed > 0) {
      time=time/(float)(speed);
    }
  }

  return time;
}


int AudioInfo::equals(AudioInfo* aInfo) {
  if (aInfo == NULL) return false;

  if (aInfo->getSpeed() != speed) {
    return false;
  }
  if (aInfo->getStereo() != stereo) {
    return false;
  }
  if (aInfo->getSampleSize() != samplesize) {
    return false;
  }
  return true;
} 


void AudioInfo::copyTo(AudioInfo* aInfo) {
  if (aInfo == NULL) {
    cout << "copying NULL pointer ignored"<<endl;
    return;
  } 
  aInfo->setSpeed(getSpeed());
  aInfo->setStereo(getStereo());
  aInfo->setSampleSize(getSampleSize());
  aInfo->setChange(getChange());
} 
 


void AudioInfo::print() {
  cout << "AudioInfo-begin-"<<endl;
  cout << "stereo:"<<getStereo()<<" sampleSize:"<<getSampleSize()
       << " speed: "<<getSpeed()<<endl;

  cout << "AudioInfo-end-"<<endl;
 
}
