/*
  mechanism for easy (fast) detection if an object has changed internally
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __INFO_H
#define __INFO_H



/**
  This class is delveloped for the entry in a deviceConfig 
  class.<p>
  The producer delivers data to all connected listeners.
  Each listerner must check if the data in which
  he is interested has changed.
  During a "trip" through the graph each listener calls
  getChange()
  on the entry in the deviceConfig. If it changed the listener
  can do something.
  After a "trip" the streamProducer calls on the deviceConfig:
  <p>
  setChangeToAll(false);
  <p>
  This sets the changed entry to false in all entries in the 
  deviceConfig. If then a producer detects a change
  he sets only the entries which really changes with setChange(true)
  <p>
  The valid flag is used by a producer. Sometime the data for a
  info structure is delievered asynchronly. E.g: First the music name
  is changed, and then the len of the music. After the name change
  the info is invalid, because it is in a state between old (old len) and
  new (new name).
  After the information is set completly, the producer sets the valid
  flag.<p>
  Only valid data can be delivered through the yaf-graph!<p>
  The default value for valid is true.
  
*/


class Info {

  int change;
  int valid;

 public:

  Info();
  ~Info();

  int getValid();
  void setValid(int valid);

  void setChange(int lChange);
  int getChange();

};


#endif
