/*
  encapsulates memory
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deviceConfig/mem/memChunk.h>


MemChunk::MemChunk(MemManager* memManager,int aSize) {
  init(memManager,aSize);
}


MemChunk::MemChunk(int size) {
  init((MemManager*)NULL,size);
}

void MemChunk::init(MemManager* memManager,int aSize) {
  if (memManager == NULL) {
    this->memManager=new MemManager();
    lInternalMemManager=true;
  } else {
    this->memManager=memManager;
    lInternalMemManager=false;
  }
  this->size=0;
  pthread_mutex_init(&mut,NULL);
  pthread_cond_init(&unlockCond,NULL);

  resize(aSize);
  resetLocks(); 
}


MemChunk::~MemChunk(){
  if (nLocks > 0) {
    cout << "on this memChunk are locks! Wait for unlock"<<endl;
    waitForUnlock();
    cout << "all locks released! destruktor continouse"<<endl;
    
  }
  
  if (size > 0) {
    delete ptr;
  }
  if (lInternalMemManager) {
    delete memManager;
  }
}


void MemChunk::resize(int aSize) {
  if (size > 0) {
    delete ptr;
  }
  ptr=NULL;
  size=aSize;
  len=0;
  if (size <= 0) return;
  ptr=new char[size];
}


int MemChunk::getSize() {
  return size;
}
 

char* MemChunk::getPtr() {
  return ptr;
}


void MemChunk::setPtr(char* ptr) {
  if (nLocks != 0) {
    memManager->lockMemManager();
    memManager->lockViolation(this);
    memManager->unlockMemManager();
  }
  if (size == 0) {
    this->ptr=ptr;
    return;
  }
  memcpy(this->ptr,ptr,size);
}


int MemChunk::getLen() {
  return len;
}


void MemChunk::setLen(int len) {
  this->len=len;
}


int MemChunk::getLocks() {
  return nLocks;
}

void MemChunk::resetLocks() {
  nLocks=0;
  lConfirmed=false;
}


void MemChunk::addLock() {
  pthread_mutex_lock(&mut);
  nLocks++;
  if ((nLocks == 1) && (lConfirmed == false)) {
    memManager->lockMemManager();
    memManager->lockMemChunk(this);
    memManager->unlockMemManager();
    lConfirmed=true;
  }
  pthread_mutex_unlock(&mut);
  
}


void MemChunk::removeLock() {
  pthread_mutex_lock(&mut);
  nLocks--;
  if ((nLocks == 0) && (lConfirmed == true)){
    memManager->lockMemManager();
    memManager->unlockMemChunk(this);
    memManager->unlockMemManager();
  }
  if (nLocks < 0) {
    memManager->lockViolation(this);
  }
  pthread_cond_signal(&unlockCond);
  pthread_mutex_unlock(&mut);
}

void MemChunk::print() {
  cout << "MemChunk-begin"<<this<<endl;
  cout << "size: "<<size<<" len: "<<len<<" lock:"<<nLocks<<endl;
  cout << "MemChunk-end"<<endl;
}


void MemChunk::waitForUnlock() {
  pthread_mutex_lock(&mut);
  while (nLocks > 0) {
    pthread_cond_wait(&unlockCond,&mut);
  }
  pthread_mutex_unlock(&mut);
}
  


void MemChunk::switchBackToInternalMemManager() {
  this->memManager=new MemManager();
  lInternalMemManager=true;
}


int MemChunk::overflowDanger() {
  return memManager->overflowDanger();
}


