/*
  stores deviceConfigFifos (each streamProducer in a seperate column)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef _MULTIQUEUEFIFO_H
#define _MULTIQUEUEFIFO_H

#include <deviceConfig/deviceConfigArray.h>
#include <deviceConfig/deviceConfigFifo.h>
#include <devices/nodeDevice.h>

/**
  This class can manage a deviceConfigFifo for each source.
  With this class it is possible that multiple sources
  write their DeviceConfig into the queue and if all of
  them have at least one entry you can simultaneously dequeue 
  the entry and pass them to a mixer device.
  <p>
  This class internally has switches for dequeing, but there
  are currently no public methods because the used
  algorithms work all in realtime.(At least on my cpu)

*/




#define _MAX_QUEUE_ENTRIES    5


class MultiQueueFifo {

  DeviceConfigFifo* fifoQueue[_MAX_QUEUE_ENTRIES];
  DeviceConfigArray* confArray;
  int queueCount;

 public:
  MultiQueueFifo();
  ~MultiQueueFifo();

  int canSimultaneousDequeue();
  void enqueue(NodeDevice* id,DeviceConfig* config);
  
  DeviceConfigArray* multiDequeue();
  void multiForward();


  void insert(DeviceConfigFifo* deviceConfigFifo);
  void remove(NodeDevice* id);
  int getQueueCount();

  /**
     returns true if all fifos are empty == filgrade == 0
  */
  int isEmpty();

  /**
     returns true if all fifos are stopped
  */
  int isStopped();

  /**
     returns true if all fifos are paused
  */
  int isPaused();

  void clear(NodeDevice* id);
  void print();

 private:
  // returns position in Array with this source (or -1 if not found)
  int findQueue(NodeDevice* nodeDevice);
  // returns position which is empty. (or -1 if non is empty)
  int findEmpty();
  /**
     After this call a thread is wakeup
  */
  void sigHUP();
  
};

#endif
