/*
  generic audiodevice
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __ESDDEVICE_H
#define __ESDDEVICE_H


#include <devices/outputDevice.h>
#include <devices/nativeMixerDevice.h>
#include <devices/audioDevice.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

extern "C" {
#include <stdio.h>
	   }



class ESDDevice :public OutputDevice {

  StatusInfo* statusInfo;
  NativeMixerDevice* nativeMixerDevice;

  int lneedInit;
  int lAutoInit;
  int lEnabled;

 public:
  ESDDevice();
  ~ESDDevice();

  int getEnabled();
  void setEnabled(int lEnable);

  int isCompiledIn();


  int open();
  int close();
  int isOpen();
  
  int init(int sampleSize,int speed,int stereo);

  int getAutoInit();
  void setAutoInit(int lAutoInit);

  StatusInfo* getStatusInfo();
  char* getNodeName();
  
  void writeIn(NodeDevice* source,DeviceConfig* buf);
  // Special functions for device
  
  int rawWrite(char* buf,int len);

 private:
   int init(int lForceSet);

   int sock;
   int rate;
   int bits;
   int channels;
   int mode;
   int func;
   char* host;
   char* name;
 
};

#endif
  
  
