/*
  device for network ausdio
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __NASDEVICE_H
#define __NASDEVICE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <devices/streamProducer.h>
#include <signal/toolkit/notifyClient.h>
#include <devices/qwAudio-p.h>
#include <devices/nasDeviceVirtual.h>
#include <devices/audioDevice.h>

#define _NAS_DATA_TO_WRITE 65
#define _NAS_VOLUME_TO_SET 66
#define _NAS_INIT_TO_DO    67
#define _NAS_STREAM_CHANGE 68


#include <stdio.h>


#ifndef _HAVE_NAS
class NASDevice :public NASDeviceVirtual {

 public:
  NASDevice(){};
  ~NASDevice(){};
};
#endif


#ifdef _HAVE_NAS

/**
   The nasDevice ias a node wich streams audioData to
   a Network Audio Server (NAS). NAS ist supported by all newer
   NCD XTerminal. 
   <p>
   The implementation is a bit (better: very) ugly. This is because NAS 
   had _major_ problems with threads.
   The bug workaround is to pass the data from the thread over
   some ringbuffer to the native (main) thread.
   <p>
   This did work here, thus don't look at the code.
*/ 


class NASDevice :public NASDeviceVirtual,public NotifyClient {

  // variables for nas conection
  QwAuServer* qwAuServer;  
  AuServer* auServer;
  AuDeviceID auDeviceID;
  AuFlowID auFlowID;
  int gain;
  AuBool   gainAdjustable;
  int matchDevice;

  AudioInfo* audioInfo;
  VolumeInfo* volumeInfo;
  StatusInfo* statusInfo;
  int lneedInit;
  int lAutoInit;
  int lCanWrite;

 public:
  NASDevice();
  ~NASDevice();

  // displayString eg: tcp/host.domain.com:8000
  int open(char* displayString);

  int getGain();
  // gain from 0..100
  void setGain(int val); 

  const char* getServerString();
  const char* getVendorString();
  int getMajorProtocolVersion();
  int getMinorProtocolVersion();

  int close();
  int isOpen();
  
  char* getNodeName();
  int isCompiledIn();
  
  void writeIn(NodeDevice* source,DeviceConfig* buf);
  // Special functions for device
  
  AuBool nasEventHandler(AuServer* audioServer,
			 AuEvent* auEvent,
			 AuEventHandlerRec* auEventHandlerRec);
  
 private:
   int init(int sampleSize,int speed,int stereo);
   int init(int lForceSet);
   void nasSetVolume(float left,float right); 
   int rawWrite(char* buf,int len);
   void processEvent(char msgId);
   void sendDataToNASServer(int bytes);
   int createFlow();
   void destroyFlow();
   int hasFlow();
};

#endif

// from global ifdef __NASDEVICE_H
#endif
  
