/*
  virtual dummy implementation for a NASDevice 
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <nasDeviceVirtual.h>


NASDeviceVirtual::NASDeviceVirtual():OutputDevice("NASDevice") {
  lEnabled=false;
}


NASDeviceVirtual::~NASDeviceVirtual() {
}

int NASDeviceVirtual::getEnabled() {
  return lEnabled;
}


void NASDeviceVirtual::setEnabled(int lEnable){
  // block the device for a short time
  writeInLock();
  this->lEnabled=lEnable;
  writeInUnlock();
  if ((isOpen() == true) && (lEnable==false)) {
    close();
  }
}
 
int NASDeviceVirtual::open(char*){
  return false;
}

char* NASDeviceVirtual::getDisplay(){
  return "not supported";
}

void NASDeviceVirtual::setDisplay(char*){
}
 
int NASDeviceVirtual::getGain(){
  return 0;
}

void NASDeviceVirtual::setGain(int){
} 

const char* NASDeviceVirtual::getServerString(){
  return "no NAS support compiled";
}


const char* NASDeviceVirtual::getVendorString(){
  return "no NAS support compiled";
}

int NASDeviceVirtual::getMajorProtocolVersion(){
  return 0;
}

int NASDeviceVirtual::getMinorProtocolVersion(){
  return 0;
}

int NASDeviceVirtual::close(){
  return true;
}

int NASDeviceVirtual::isOpen(){
  return false;
}

char* NASDeviceVirtual::getNodeName(){
  return "NASDeviceVirtual";
}

void NASDeviceVirtual::writeIn(NodeDevice* ,DeviceConfig* ){
  cout << "entering NASDeviceVirtual (not compiled?)"<<endl;
}


int NASDeviceVirtual::isCompiledIn(){
  return false;
}
