/*
  eventclass for global events
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __YAFEVENT_H
#define __YAFEVENT_H

#include <qevent.h>

// Event_User starts with 1000 in qt2 we must use QEvent::Event_User
// (which is 1000 as well) thus this works for both versions.

#define __YAFGLOBALEVENT_ID     1100

/**
   Why global/local events?
   <p>
   The problem is that you cannot safely delete devices on local
   events. QT emit-signals are not inserted in a global
   eventqueue, and this means, that if you delete a device
   on a signal emitted by a device you delete the execution
   stack of the signal as well!<p>
   This normally leads to segfaults.
   <p>
   global Events are not passed directly by the device but
   by the global eventqueue of the application.
   On these events it is safe to delete a device.
   <p>
   The difference between local and global events is the order
   of execution and the speed. 
   Local events are very fast, because the always only send
   a single char as argument and they are sended by the 
   device directly to the receiver.
   <p>
   Global events are slow, because they are allocated on the
   heap and then are inserted in the global queue.
   But on a global event it is safe to delete the devices.
*/


class YafGlobalEvent : public QEvent {
  
  int msg;

 public:
  YafGlobalEvent();
  ~YafGlobalEvent();

  int getMsg();
  void setMsg(int msg);

};
#endif

