//
// /home/ms/sidplay/qtsidplay/RCS/EmuDialog.cpp,v
//

#include <kapp.h>
#include "GlobalExt.h"
#include "EmuDialog.h"

#define Inherited EmuDialogData

EmuDialog::EmuDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( i18n("Emulation") );
	setFixedSize(width(),height());
	setIcon(*myMainIcon);

	presetButtons();
}

EmuDialog::~EmuDialog()
{
}

void EmuDialog::presetButtons()
{
	SIDfilter->setChecked(myEmuConfig.emulateFilter);
	measVol->setChecked(myEmuConfig.measuredVolume);
	mos8580->setChecked(myEmuConfig.mos8580);
	forceSS->setChecked(myEmuConfig.forceSongSpeed);
	
	fullBS->setChecked(myEmuConfig.memoryMode==MPU_BANK_SWITCHING);
	transROM->setChecked(myEmuConfig.memoryMode==MPU_TRANSPARENT_ROM);
	psidEnv->setChecked(myEmuConfig.memoryMode==MPU_PLAYSID_ENVIRONMENT);

	clockPAL->setChecked(myEmuConfig.clockSpeed==SIDTUNE_CLOCK_PAL);
	clockNTSC->setChecked(myEmuConfig.clockSpeed==SIDTUNE_CLOCK_NTSC);
}

void EmuDialog::receiveEMUfilterFlag(bool val)
{
	SIDfilter->setChecked(val);
	SIDfilter->repaint();
}

void EmuDialog::newEMUsetting(int)
{
	myEmuConfig.emulateFilter = SIDfilter->isChecked();
	myEmuConfig.mos8580 = mos8580->isChecked();
	myEmuConfig.measuredVolume = measVol->isChecked();
	myEmuConfig.forceSongSpeed = forceSS->isChecked();
	myEmuEngine.setConfig(myEmuConfig);
	emit sendEmuFilterFlag(SIDfilter->isChecked());
}

void EmuDialog::newMPUsetting(int)
{
	if (fullBS->isChecked())
		myEmuConfig.memoryMode = MPU_BANK_SWITCHING;
	else if (transROM->isChecked())
		myEmuConfig.memoryMode = MPU_TRANSPARENT_ROM;
	else  // if (psidEnv->isChecked())
		myEmuConfig.memoryMode = MPU_PLAYSID_ENVIRONMENT;
	myEmuEngine.setConfig(myEmuConfig);
}

void EmuDialog::newCLKsetting(int)
{
	if (clockPAL->isChecked())
		myEmuConfig.clockSpeed = SIDTUNE_CLOCK_PAL;
	else  // if (clockNTSC->isChecked())
		myEmuConfig.clockSpeed = SIDTUNE_CLOCK_NTSC;
	myEmuEngine.setConfig(myEmuConfig);
}
