/***************************************************************************
                          ksoundrecordview.cpp  -  description
                             -------------------
    begin                : Don Jan  6 20:17:39 CET 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qtooltip.h>
#include <qpixmap.h>

// application specific includes
#include "ksoundrecordview.h"
#include "ksoundrecorddoc.h"
#include "ksoundrecord.h"
#include "kiconloader.h"
#include "klocale.h"


KsoundrecordView::KsoundrecordView(QWidget *parent, const char *name) : QWidget(parent, name)
{
  setBackgroundMode(PaletteBase);
  setBackgroundColor(darkGray.dark(120));

  timer = new QTimer();

  timelcd = new QLCDNumber(this);
  timelcd->move(59,14);
  timelcd->setNumDigits(8);
  timelcd->resize(180,50);

  rec_button = new QPushButton(this);
  rec_button->setPixmap(ICON("record_ksr.xpm"));
  rec_button->setGeometry(30,92,40,25);
  QToolTip::add (rec_button,i18n("recording"));

  stop_button = new QPushButton(this);
  stop_button->setPixmap(ICON("stop_ksr.xpm"));
  stop_button->setGeometry(80,92,40,25);
  QToolTip::add (stop_button,i18n("stop"));

  play_button = new QPushButton(this);
  play_button->setPixmap(ICON("play_ksr.xpm"));
  play_button->setGeometry(130,92,40,25);
  QToolTip::add (play_button,i18n("play"));

  mp3_button = new QPushButton(this);
  mp3_button->setPixmap(ICON("mp3_ksr.xpm"));
  mp3_button->setGeometry(180,92,40,25);
  QToolTip::add (mp3_button,i18n("encoding to mp3"));

	mp3_play_button = new QPushButton(this);
  mp3_play_button->setPixmap(ICON("mp3_play_ksr.xpm"));
  mp3_play_button->setGeometry(230,92,40,25);
  QToolTip::add (mp3_play_button,i18n("Start XMMS"));

  output_window = new out();
  options_dialog = new options();
  file_list = new list();

  connect(rec_button,SIGNAL(clicked()),this->parent(),SLOT(slotRec()));
 	connect(stop_button,SIGNAL(clicked()),this->parent(),SLOT(slotStop()));
  connect(play_button,SIGNAL(clicked()),this->parent(),SLOT(slotPlay()));
  connect(mp3_button,SIGNAL(clicked()),this->parent(),SLOT(slotEncode()));
	connect(mp3_play_button,SIGNAL(clicked()),this->parent(),SLOT(slot_mp3_play()));
  connect(timer,SIGNAL(timeout()),this,SLOT(slotlcd()));
  connect(options_dialog->vbr,SIGNAL(toggled(bool)),this,SLOT(slot_enable_vbr(bool)));
}

KsoundrecordView::~KsoundrecordView()
{
}

KsoundrecordDoc *KsoundrecordView::getDocument() const
{
  KsoundrecordApp *theApp=(KsoundrecordApp *) parentWidget();

  return theApp->getDocument();
}

void KsoundrecordView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

  printpainter.end();
}
/**  */
void KsoundrecordView::slotstdout(bool show){
	if (show)
		output_window->show();
	else
		output_window->hide();
}
/**LCD Time*/
void KsoundrecordView::slotlcd(){
	zeit++;
	int sec,min,h,rest;
	QString lcdsec,lcdmin,lcdh;
	h = zeit/3600;
	lcdh.setNum(h);
	if (h<10)
		lcdh = "0" + lcdh;
	rest = zeit%3600;
	min = rest/60;
	lcdmin.setNum(min);
	if (min<10)
		lcdmin = "0" + lcdmin;
	sec = rest%60;
	lcdsec.setNum(sec);
	if (sec<10)
		lcdsec = "0" + lcdsec;
	timelcd->display(lcdh + ":" + lcdmin + ":" + lcdsec);
}
/**  */
void KsoundrecordView::slot_enable_vbr(bool enable){
	if(enable)
	{
		options_dialog->label_vbr->setEnabled(true);
		options_dialog->label_bitrate_freq2->setEnabled(false);
		options_dialog->label_bitrate_freq1->setEnabled(false);
		options_dialog->label_bitrate_freq3->setEnabled(false);
		options_dialog->label_bitrate->setEnabled(false);
		options_dialog->vbr_slider->setEnabled(true);
		options_dialog->bitrate_slider->setEnabled(false);
		options_dialog->vbr->setChecked(enable);
	}
	else
	{	
		options_dialog->label_vbr->setEnabled(false);
		slot_show_freq(-1);
		options_dialog->vbr_slider->setEnabled(false);
		options_dialog->bitrate_slider->setEnabled(true);
		options_dialog->label_bitrate->setEnabled(true);
		options_dialog->label_bitrate_freq3->setEnabled(true);
		options_dialog->vbr->setChecked(enable);	
 	}
}
/**  */
void KsoundrecordView::slot_show_freq(int br){
	static int lbr=0;
	options_dialog->label_bitrate_freq2->setEnabled(false);
	options_dialog->label_bitrate_freq1->setEnabled(false);
	if(br!=-1)
		lbr = br;
	if(lbr==1| lbr ==2 | lbr==3| lbr ==4 | lbr==5| lbr ==6 | lbr==7| lbr ==8 | lbr==9| lbr ==10 | lbr==11| lbr ==12 | lbr==13| lbr ==14)
		options_dialog->label_bitrate_freq2->setEnabled(true);
	if(lbr==4 | lbr==6 | lbr ==7 | lbr==8 | lbr ==9 | lbr==10| lbr ==11 | lbr==12| lbr ==14 | lbr==15| lbr ==16 | lbr==17| lbr ==18)
		options_dialog->label_bitrate_freq1->setEnabled(true);	
}
/**  */

