/***************************************************************************
                          ksoundrecordview.h  -  description
                             -------------------
    begin                : Don Jan  6 20:17:39 CET 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSOUNDRECORDVIEW_H
#define KSOUNDRECORDVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlcdnumber.h>
#include <qstring.h>
#include <qstrlist.h>

#include "out.h"
#include "options.h"
#include "list.h"

class KsoundrecordDoc;

/** The KsoundrecordView class provides the view widget for the KsoundrecordApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KsoundrecordView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KsoundrecordApp class to manipulate and display
 * the document structure provided by the KsoundrecordDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KsoundrecordView : public QWidget
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    KsoundrecordView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KsoundrecordView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a KsoundrecordApp instance as a parent
     * widget to get to the window document pointer by calling the KsoundrecordApp::getDocument() method.
     *
     * @see KsoundrecordApp#getDocument
     */
    KsoundrecordDoc *getDocument() const;

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
	
  private:
public: // Public attributes
  /**  */
  QPushButton* rec_button;
	QPushButton* play_button;
  QPushButton* stop_button;
  QPushButton* mp3_button;
	QPushButton* mp3_play_button;

  /** stdout or sterr from console-applications */
  out* output_window;
  /** dialog for options */
  options* options_dialog;
  list* file_list;

  QTimer* timer;
  /**  */
  QLCDNumber* timelcd;
  /**  */
  int zeit;
 	
public slots: // Public slots
  /**  */
  void slotstdout(bool);
  /**  */
  void slotlcd();
  /**  */
  void slot_enable_vbr(bool);
  /**  */
  void slot_show_freq(int);
};

#endif // KSOUNDRECORDVIEW_H
