/***************************************************************************
                          ccomplex.cpp  -  description
                             -------------------
    begin                : Thu Dec 30 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ccomplex.h"
#include <math.h>

CComplex::CComplex(const CComplex &c)
{
 	m_r = c.m_r;
 	m_i = c.m_i;
}

CComplex::CComplex(double r = 0,double i = 0)
{
	m_r = r;
	m_i = i;
}

CComplex::~CComplex()
{
}
	
double		&CComplex::real()
{
	return m_r;
}

double		&CComplex::imaginaer()
{
	return m_i;
}
	
double		CComplex::amount()
{
	return sqrt(m_r * m_r + m_i * m_i);
}

CComplex	&CComplex::operator=(const CComplex &c)
{
	m_r = c.m_r;
	m_i = c.m_i;
	
	return *this;
}

CComplex CComplex::operator+(const CComplex &c)
{
	return CComplex(m_r + c.m_r,m_i + c.m_i);
}
	
CComplex CComplex::operator-(const CComplex &c)
{
	return CComplex(m_r - c.m_r,m_i - c.m_i);
}

CComplex CComplex::operator*(const CComplex &c)
{
	return CComplex(m_r * c.m_r - m_i * c.m_i,m_r * c.m_i + m_i * c.m_r);
}
	
CComplex CComplex::operator/(const CComplex &c)
{
	double	divisor;

	divisor = m_i * m_i + c.m_i * c.m_i;
	
	return CComplex((m_r * c.m_r + m_i * c.m_i) / divisor,(m_i * c.m_r - m_r * c.m_i) / divisor);
}

