/***************************************************************************
                          kaudio.h  -  description
                             -------------------
    begin                : Sat Apr 22 2000
    copyright            : (C) 2000 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KAUDIO_H
#define KAUDIO_H

#include <qobject.h>

/**this class is an interface for all audio uses
  *@author Tobias Wollgam
  */

class KAudio : public QObject
{
public: 
	KAudio();
	~KAudio();
	
	void			setDSPDevice(const char*,int n = 0);
	QString		getDSPDevice(int n = 0);
	
	bool			haveDSPDevice(int n = 0);
	
	bool			configureChannel(int n,int dev,bool left,int vol);
	
	bool			playMono(void *data,int len,int samplesize,int rate,int channeln);
	bool			playStereo(void *data,int len,int samplesize,int rate,int channelnleft,int channelnright);
	
	bool			areaLocked(void *data);
	
private:
	int				channel_dev[16];
	bool			channel_side[16];
	int				channel_vol[16];
	void			*channel_data[16];
	int				channel_data_len[16];
	int				channel_data_rate[16];
	int				channel_data_size[16];
	int				channel_data_mode[16];
					
	int				dsp_speed;
	int				dsp_stereo;
	int				dsp_samplesize;
	int				buffer_size;
	int				audio[4];
	QString		audio_dev[4];
	void			*buffer,*b[4];
	uint			spb;
	uint			start_pos,end_pos,current_pos;
};

#endif
