/***************************************************************************
                          ksoundsys.cpp  -  description
                             -------------------
    begin                : Sun Dec 26 01:22:14 CET 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include <ksoundsys.h>
#include "ksoundsysview.h"
#include "ksoundsysdoc.h"
#include "kssdialogs.h"
#include "resource.h"


KSoundSysApp::KSoundSysApp(CSample &cnps) : m_cutnpastesample(cnps)
{
	config=kapp->getConfig();

/*
	if(cnps == 0)
	{
		m_cutnpastesample = new CSample();
		m_mysample = true;
	}
	else
	{
		m_cutnpastesample = cnps;
		m_mysample = false;
	}
*/		
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initKeyAccel();
  initDocument();
  initView();
	
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
//  disableCommand(ID_FILE_SAVE);
//  disableCommand(ID_FILE_SAVE_AS);
  disableCommand(ID_FILE_PRINT);
 	
//  disableCommand(ID_EDIT_CUT);
//  disableCommand(ID_EDIT_COPY);
//  disableCommand(ID_EDIT_PASTE);
 	
//  disableCommand(ID_AUDIO_PLAY);
  disableCommand(ID_AUDIO_PAUSE);
//  disableCommand(ID_AUDIO_STOP);
  disableCommand(ID_AUDIO_RECORD);

  disableCommand(ID_FILTER_PITCHSHIFT);
  disableCommand(ID_FILTER_TAKEPITCH);
  disableCommand(ID_FILTER_DCOFFSET);
}

KSoundSysApp::~KSoundSysApp()
{
/*
	if(m_mysample && m_cutnpastesample)
	{
		delete m_cutnpastesample;
	}
*/
}

void KSoundSysApp::initKeyAccel()
{
	key_accel = new KAccel( this );
	
	// file_menu accelerators
	key_accel->connectItem( KAccel::New, this, SLOT( slotFileNew() ) );
	key_accel->connectItem( KAccel::Open, this, SLOT( slotFileOpen() ) );
	key_accel->connectItem( KAccel::Save, this, SLOT( slotFileSave() ) );
	key_accel->connectItem( KAccel::Close, this, SLOT( slotFileClose() ) );
	key_accel->connectItem( KAccel::Print, this, SLOT( slotFilePrint() ) );
	key_accel->connectItem( KAccel::Quit, this, SLOT( slotFileQuit() ) );
	// edit_menu accelerators
	key_accel->connectItem( KAccel::Cut, this, SLOT( slotEditCut() ) );
	key_accel->connectItem( KAccel::Copy, this, SLOT( slotEditCopy() ) );
	key_accel->connectItem( KAccel::Paste, this, SLOT( slotEditPaste() ) );

	key_accel->connectItem( KAccel::Help, kapp, SLOT( appHelpActivated() ) );
			
	key_accel->changeMenuAccel(	file_menu, ID_FILE_NEW, KAccel::New );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_OPEN, KAccel::Open );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_SAVE, KAccel::Save );
	key_accel->changeMenuAccel( file_menu, ID_FILE_CLOSE, KAccel::Close );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_PRINT, KAccel::Print );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_QUIT, KAccel::Quit );

  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_CUT, KAccel::Cut );
  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_COPY, KAccel::Copy );
  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_PASTE, KAccel::Paste );

  key_accel->readSettings();	
}

void KSoundSysApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  recent_files_menu = new QPopupMenu();
  connect( recent_files_menu, SIGNAL(activated(int)), SLOT(slotFileOpenRecent(int)) );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(kapp->getMiniIcon(), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
  file_menu->insertItem(i18n("Open &recent"), recent_files_menu, ID_FILE_OPEN_RECENT );

  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
  file_menu->insertItem(i18n("Save &As..."), ID_FILE_SAVE_AS );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print..."), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  edit_menu = new QPopupMenu();
  edit_menu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT );
  edit_menu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY );
  edit_menu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE );
	edit_menu->insertSeparator();
	edit_menu->insertItem(i18n("insert Silence ..."),ID_EDIT_INSERT_SILENCE);
	edit_menu->insertSeparator();
	edit_menu->insertItem(i18n("Format ..."),ID_EDIT_FORMAT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry audio_menu
  audio_menu = new QPopupMenu();
	audio_menu->insertItem(Icon("play.xpm"), i18n("Play"),ID_AUDIO_PLAY);
	audio_menu->insertItem(Icon("stop.xpm"), i18n("Stop"),ID_AUDIO_STOP);
	audio_menu->insertItem(Icon("pause.xpm"), i18n("Pause"),ID_AUDIO_PAUSE);
	audio_menu->insertSeparator();
	audio_menu->insertItem(Icon("record.xpm"), i18n("Record"),ID_AUDIO_RECORD);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
	filter_menu = new QPopupMenu();
	filter_menu->insertItem(i18n("Volume ..."),ID_FILTER_VOLUME);
	filter_menu->insertItem(i18n("Optimize Volume"),ID_FILTER_OPTIMIZE_VOLUME);
	filter_menu->insertItem(i18n("Envelope ..."),ID_FILTER_ENVELOPE);
	filter_menu->insertItem(i18n("Distortion ..."),ID_FILTER_DISTORTION);
	filter_menu->insertItem(i18n("Compress ..."),ID_FILTER_COMPRESS);
	filter_menu->insertItem(i18n("Expand ..."),ID_FILTER_EXPAND);
	filter_menu->insertItem(i18n("DC-Offset ..."),ID_FILTER_DCOFFSET);
	filter_menu->insertItem(i18n("Optimize DC-Offset"),ID_FILTER_OPTIMIZE_DCOFFSET);
	filter_menu->insertItem(i18n("Fuzz ..."),ID_FILTER_FUZZ);
	filter_menu->insertItem(i18n("Noisegate ..."),ID_FILTER_NOISEGATE);
	filter_menu->insertSeparator();
	filter_menu->insertItem(i18n("Blur ..."),ID_FILTER_BLUR);
	filter_menu->insertItem(i18n("DeepPass ..."),ID_FILTER_DEEPPASS);
	filter_menu->insertItem(i18n("HighPass ..."),ID_FILTER_HIGHPASS);
	filter_menu->insertItem(i18n("PitchShift ..."),ID_FILTER_PITCHSHIFT);
	filter_menu->insertItem(i18n("TakePitch ..."),ID_FILTER_TAKEPITCH);
	filter_menu->insertSeparator();
	filter_menu->insertItem(i18n("Echo ..."),ID_FILTER_ECHO);
	filter_menu->insertItem(i18n("Hullcurve"),ID_FILTER_HULLCURVE);
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry generate_menu
  generate_menu = new QPopupMenu();
  generate_menu->setCheckable(true);
  generate_menu->insertItem(i18n("Sinus"), ID_GENERATE_SIN);
  generate_menu->insertItem(i18n("Square"), ID_GENERATE_SQUARE);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry option_menu
  option_menu = new QPopupMenu();
	option_menu->insertItem(Icon("palette.xpm") ,i18n("Colors"), ID_OPTION_COLORS);
	option_menu->insertItem(i18n("Hardware"), ID_OPTION_HARDWARE);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QString aboutstring=kapp->appName()+" V"+VERSION+"\n\n(c) 1999,2000 Tobias Wollgam\n\nEmail: Tobias.Wollgam@gmx.de";

  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, aboutstring );

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Edit"), edit_menu);
  menuBar()->insertItem(i18n("&Audio"), audio_menu);
  menuBar()->insertItem(i18n("Fi&lter"), filter_menu);
  menuBar()->insertItem(i18n("Generate"), generate_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);
  menuBar()->insertItem(i18n("&Options"), option_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(file_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(file_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(edit_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(edit_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(audio_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(audio_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(filter_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(filter_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(view_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(view_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(option_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(option_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(generate_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(generate_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));
}

void KSoundSysApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File") );
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File") );
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File") );
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut") );
  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy") );
  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("play.xpm"), ID_AUDIO_PLAY, true, i18n("Play") );
  toolBar()->insertButton(Icon("stop.xpm"), ID_AUDIO_STOP, true, i18n("Stop") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked() ),
  				kapp, SLOT( appHelpActivated() ), true,i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
	// connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
	// connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void KSoundSysApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
	// TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG );
}

void KSoundSysApp::initDocument()
{
  doc = new KSoundSysDoc(this);
  doc->newDocument();
}

void KSoundSysApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KSoundSysView(this,"",doc->sample());
  doc->setView(view);
  setView(view);
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());

}

void KSoundSysApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KSoundSysApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}

void KSoundSysApp::addRecentFile(const char* file)
{
  if(recent_files.find(file) == -1)
  {
    if( recent_files.count() < 9)
      recent_files.insert(0,file);
    else
    {
      recent_files.remove(8);
      recent_files.insert(0,file);
    }
	}
	else
	{
  	if(recent_files.find(file) != 0)
  	{
      recent_files.remove(recent_files.find(file));
      recent_files.insert(0,file);
    }
	}
  recent_files_menu->clear();
  for( int i = 0;i < (int)recent_files.count(); i++)
  {
    recent_files_menu->insertItem(recent_files.at(i));
  }
}

void KSoundSysApp::openDocumentFile(const char* _cmdl)
{
  slotStatusMsg(i18n("Opening file..."));
	if(doc->openDocument(_cmdl))
		addRecentFile(_cmdl);
  slotStatusMsg(i18n("Ready."));
}


KSoundSysDoc* KSoundSysApp::getDocument() const
{
	return doc;
}

void KSoundSysApp::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size() );
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos",  (int)toolBar()->barPos());
	config->writeEntry("Recent Files", recent_files);
}


void KSoundSysApp::readOptions()
{
	
	config->setGroup("General Options");

	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
	view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
	if(!bViewToolbar)
		enableToolBar(KToolBar::Hide);
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
	if(!bViewStatusbar)
		enableStatusBar(KStatusBar::Hide);
	
	// bar position settings
	KMenuBar::menuPosition menu_bar_pos;
	menu_bar_pos=(KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition tool_bar_pos;
  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

	menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);
	
  // initialize the recent file list
	recent_files.setAutoDelete(TRUE);
	config->readListEntry("Recent Files",recent_files);
	
	uint i;
	for ( i =0 ; i < recent_files.count(); i++){
    recent_files_menu->insertItem(recent_files.at(i));
  }

  QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
		resize(size);
}

void KSoundSysApp::saveProperties(KConfig* )
{
	if( doc->getTitle() != i18n("Untitled") && !doc->isModified())
	{
		return;
	}
	else
	{
		QString filename=doc->getPathName()+doc->getTitle();	
    config->writeEntry("filename",filename);
    config->writeEntry("modified",doc->isModified());
		
		const char* tempname = kapp->tempSaveName(filename);
		doc->saveDocument(tempname);
	}
}


void KSoundSysApp::readProperties(KConfig*)
{
	QString filename = config->readEntry("filename","");
	bool modified = config->readBoolEntry("modified",false);
  if( modified ){
  	bool b_canRecover;
		QString tempname = kapp->checkRecoverFile(filename,b_canRecover);
  	
  	if(b_canRecover){
   			doc->openDocument(tempname);
   			doc->setModified();
   			QFileInfo info(filename);
   			doc->pathName(info.absFilePath());
   			doc->title(info.fileName());
   			QFile::remove(tempname);
		}
	}
 	else if(!filename.isEmpty()){
		doc->openDocument(filename);
	}
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());
}		

bool KSoundSysApp::queryClose()
{
	return doc->saveModified();
}

bool KSoundSysApp::queryExit()
{
	saveOptions();
	return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KSoundSysApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
	
	KSoundSysApp* new_window = new KSoundSysApp(m_cutnpastesample);
	new_window->show();
	
  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));
	
	if(!doc->saveModified())
		return;
	
	doc->newFormatedDocument();		
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));
	
	if(!doc->saveModified())
		return;
	
	QString fileToOpen=KFileDialog::getOpenFileName(QDir::homeDirPath(), "*.wav", this, i18n("Open File..."));
	if(!fileToOpen.isEmpty())
	{
		doc->openDocument(fileToOpen);
    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
		addRecentFile(fileToOpen);
	}

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFileOpenRecent(int id_)
{
  slotStatusMsg(i18n("Opening file..."));
	
	if(!doc->saveModified())
		return;

	QString fileToOpen = recent_files.at(id_);
	
	doc->openDocument(fileToOpen);
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());
	addRecentFile(fileToOpen);

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));
	
	doc->saveDocument(doc->getPathName()+doc->getTitle());

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file under new filename..."));

	QString newName=KFileDialog::getSaveFileName(QDir::currentDirPath(), "", this, i18n("Save As..."));
	if(!newName.isEmpty()){
		QFileInfo saveAsInfo(newName);
		doc->title(saveAsInfo.fileName());
		doc->pathName(saveAsInfo.absFilePath());
		doc->saveDocument(newName);
		addRecentFile(newName);
    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
	}

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
	
	close();
}

void KSoundSysApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this)){
			view->print(&printer);
	}

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFileQuit()
{
	saveOptions();
	// close the first window, the list makes the next one the first again.
	// This ensures that queryClose() is called on each window to ask for closing
	KTMainWindow* w;
	if(memberList){
		for(w=memberList->first(); w; w=memberList->first()){
			// only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
			// the window and the application stay open.
			if(!w->close())
				break;
		}
	}	
}

void KSoundSysApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  doc->cut(m_cutnpastesample);

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));

  doc->copy(m_cutnpastesample);

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));

  doc->paste(m_cutnpastesample);

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotEditFormat()
{
  slotStatusMsg(i18n("Changing Sampleformat..."));

  doc->changeFormat();

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotEditInsertSilence()
{
  slotStatusMsg(i18n("Inserting Silence..."));

  doc->insertSilence();

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFilterOptimizeVolume()
{
  slotStatusMsg(i18n("Optimize Volume..."));

  doc->optimizeVolume();

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotFilterOptimizeDCOffset()
{
  slotStatusMsg(i18n("Optimize DCOffset..."));

  doc->optimizeDCOffset();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterVolume()
{
  slotStatusMsg(i18n("Change Volume..."));

  doc->volume();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterDCOffset()
{
  slotStatusMsg(i18n("Change DC-Offset..."));

  doc->changeDCOffset();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterNoisegate()
{
  slotStatusMsg(i18n("Noisegate..."));

  doc->noisegate();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterBlur()
{
  slotStatusMsg(i18n("Blur..."));

  doc->blur();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterDeeppass()
{
  slotStatusMsg(i18n("Deeppass..."));

  doc->deeppass();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterHighpass()
{
  slotStatusMsg(i18n("Highpass..."));

  doc->highpass();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterHullcurve()
{
  slotStatusMsg(i18n("Hullcurve..."));

  doc->hullcurve();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterPitchshift()
{
  slotStatusMsg(i18n("Shift Pitch..."));

  doc->pitchshift();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterTakePitch()
{
  slotStatusMsg(i18n("Take Pitch..."));

  doc->takepitch();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterCompress()
{
  slotStatusMsg(i18n("Compress..."));

  doc->compress();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterExpand()
{
  slotStatusMsg(i18n("Expand..."));

  doc->expand();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterFuzz()
{
  slotStatusMsg(i18n("Fuzz..."));

  doc->fuzz();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterEnvelope()
{
  slotStatusMsg(i18n("Envelope..."));

  doc->envelope();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterDistort()
{
  slotStatusMsg(i18n("Distort..."));

  doc->distort();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotFilterEcho()
{
  slotStatusMsg(i18n("Echo..."));

  doc->echo();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotAudioPlay()
{
  slotStatusMsg(i18n("Playing..."));

  doc->play();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotAudioStop()
{
  slotStatusMsg(i18n("Stopping..."));

  doc->stop();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotAudioPause()
{
  slotStatusMsg(i18n("Pause..."));

  doc->pause();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotAudioRecord()
{
  slotStatusMsg(i18n("Recording..."));

  doc->record();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotGenerateSin()
{
  slotStatusMsg(i18n("Generating Sinus..."));

  doc->insertSinus();

  slotStatusMsg(i18n("Ready."));
}

/**  */
void KSoundSysApp::slotGenerateSquare()
{
  slotStatusMsg(i18n("Generating Square..."));

  doc->insertSquare();

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
	if( view_menu->isItemChecked(ID_VIEW_TOOLBAR))
	  view_menu->setItemChecked(ID_VIEW_TOOLBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_TOOLBAR, true);
		
  enableToolBar();

  slotStatusMsg(i18n("Ready."));
}

void KSoundSysApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
	if( view_menu->isItemChecked(ID_VIEW_STATUSBAR))
	  view_menu->setItemChecked(ID_VIEW_STATUSBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_STATUSBAR, true);

  enableStatusBar();

  slotStatusMsg(i18n("Ready."));
}


void KSoundSysApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KSoundSysApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KSoundSysApp::commandCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
    	slotFileNewWindow();
    	break;
    case ID_FILE_NEW:
    	slotFileNew();
    	break;
    case ID_FILE_OPEN:
    	slotFileOpen();
    	break;
    case ID_FILE_SAVE:
    	slotFileSave();
    	break;
    case ID_FILE_SAVE_AS:
    	slotFileSaveAs();
    	break;
    case ID_FILE_CLOSE:
    	slotFileClose();
    	break;
    case ID_FILE_PRINT:
    	slotFilePrint();
    	break;
    case ID_FILE_QUIT:
    	slotFileQuit();
    	break;

    case ID_EDIT_CUT:
    	slotEditCut();
    	break;
    case ID_EDIT_COPY:
    	slotEditCopy();
    	break;
    case ID_EDIT_PASTE:
    	slotEditPaste();
    	break;
    case ID_EDIT_INSERT_SILENCE:
    	slotEditInsertSilence();
    	break;
    case ID_EDIT_FORMAT:
    	slotEditFormat();
    	break;

    case ID_AUDIO_PLAY:
    	slotAudioPlay();
    	break;
    case ID_AUDIO_STOP:
    	slotAudioStop();
    	break;
    case ID_AUDIO_PAUSE:
    	slotAudioPause();
    	break;
    case ID_AUDIO_RECORD:
    	slotAudioRecord();
    	break;

    case ID_FILTER_OPTIMIZE_VOLUME:
    	slotFilterOptimizeVolume();
    	break;
    case ID_FILTER_OPTIMIZE_DCOFFSET:
    	slotFilterOptimizeDCOffset();
    	break;
    case ID_FILTER_VOLUME:
    	slotFilterVolume();
    	break;
    case ID_FILTER_DCOFFSET:
    	slotFilterDCOffset();
    	break;
    case ID_FILTER_NOISEGATE:
    	slotFilterNoisegate();
    	break;
    case ID_FILTER_HULLCURVE:
    	slotFilterHullcurve();
    	break;
    case ID_FILTER_EXPAND:
    	slotFilterExpand();
    	break;
    case ID_FILTER_COMPRESS:
    	slotFilterCompress();
    	break;
    case ID_FILTER_DISTORTION:
    	slotFilterDistort();
    	break;
    case ID_FILTER_ENVELOPE:
    	slotFilterEnvelope();
    	break;
    case ID_FILTER_DEEPPASS:
    	slotFilterDeeppass();
    	break;
    case ID_FILTER_BLUR:
    	slotFilterBlur();
    	break;
    case ID_FILTER_HIGHPASS:
    	slotFilterHighpass();
    	break;
    case ID_FILTER_PITCHSHIFT:
    	slotFilterPitchshift();
    	break;
    case ID_FILTER_FUZZ:
    	slotFilterFuzz();
    	break;
    case ID_FILTER_ECHO:
    	slotFilterEcho();
    	break;
    case ID_FILTER_TAKEPITCH:
    	slotFilterTakePitch();
    	break;

    case ID_GENERATE_SIN:
    	slotGenerateSin();
    	break;
    case ID_GENERATE_SQUARE:
    	slotGenerateSquare();
    	break;

    case ID_OPTION_COLORS:
    	slotOptionColors();
    	break;
    case ID_OPTION_HARDWARE:
    	slotOptionHardware();
    	break;

    case ID_VIEW_TOOLBAR:
    	slotViewToolBar();
    	break;
    case ID_VIEW_STATUSBAR:
    	slotViewStatusBar();
    	break;
    default:
    	break;
  }
}

void KSoundSysApp::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
    	slotStatusHelpMsg(i18n("Opens a new application window"));
    	break;
    case ID_FILE_NEW:
 	  	slotStatusHelpMsg(i18n("Creates a new document"));
 	  	break;
    case ID_FILE_OPEN:
 	  	slotStatusHelpMsg(i18n("Opens an existing document"));
 	  	break;
    case ID_FILE_OPEN_RECENT:
 	  	slotStatusHelpMsg(i18n("Opens a recently used file"));
 	  	break;
    case ID_FILE_SAVE:
 	  	slotStatusHelpMsg(i18n("Save the actual document"));
 	  	break;
    case ID_FILE_SAVE_AS:
 	  	slotStatusHelpMsg(i18n("Save the document as..."));
 	  	break;
    case ID_FILE_CLOSE:
    	slotStatusHelpMsg(i18n("Closes the actual file"));
    	break;
    case ID_FILE_PRINT:
    	slotStatusHelpMsg(i18n("Prints the current document"));
    	break;
    case ID_FILE_QUIT:
    {
    	QString caption=kapp->getCaption();
    	slotStatusHelpMsg(i18n("Exits "+ caption));
    	break;
    }
    case ID_EDIT_CUT:
    	slotStatusHelpMsg(i18n("Cuts the selected section and puts it to the clipboard"));
    	break;
    case ID_EDIT_COPY:
    	slotStatusHelpMsg(i18n("Copys the selected section to the clipboard"));
    	break;
    case ID_EDIT_PASTE:
    	slotStatusHelpMsg(i18n("Pastes the clipboard contents to actual position"));
    	break;
    case ID_EDIT_INSERT_SILENCE:
    	slotStatusHelpMsg(i18n("Inserts silence to actual position"));
    	break;
    case ID_EDIT_FORMAT:
    	slotStatusHelpMsg(i18n("Changes the sampleformat"));
    	break;

    case ID_VIEW_TOOLBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Toolbar"));
    	break;
    case ID_VIEW_STATUSBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Statusbar"));
    	break;
		default:
			break;
  }
}


/**  */
void KSoundSysApp::slotOptionColors()
{
	QColor		*cp[11];
	QColor		c[11];
	int				t;

	view->getColors(c);

	for(t = 0;t < 11;t++)
	{
		cp[t] = new QColor(c[t]);
	}

	colordialog	cd(0,"Color",cp);

	cd.show();

	if(cd.result())
	{
		cd.getColors(cp);

		for(t = 0;t < 11;t++)
		{
			c[t] = *cp[t];
		}

		view->setColors(c);
		
		config->setGroup("SoundWidgetColors");
		config->writeEntry("Background",c[0]);
		config->writeEntry("Foreground",c[1]);
		config->writeEntry("NoColor",c[2]);
		config->writeEntry("Middleline",c[3]);
		config->writeEntry("Devideline",c[4]);
		config->writeEntry("SelectedBackground",c[5]);
		config->writeEntry("SelectedForeground",c[6]);
		config->writeEntry("SelectedMiddleline",c[7]);
		config->writeEntry("Pointer",c[8]);
		config->writeEntry("SelectedPointer",c[9]);
		config->writeEntry("Zoom",c[10]);
		config->sync();
	}

	for(t = 0;t < 11;t++)
	{
		delete cp[t];
	}
}

/**  */
void KSoundSysApp::slotOptionHardware()
{
	optiondialog	od(0,"Hardware");

	config->setGroup("Options/Hardware");
	od.setDSP(config->readEntry("DSP-Device0","/dev/dsp"),0);
	od.setDSP(config->readEntry("DSP-Device1","/dev/dsp1"),1);
	
	od.show();

	if(od.result())
	{
		config->setGroup("Options/Hardware");
		config->writeEntry("DSP-Device0",od.getDSP(0));
		config->writeEntry("DSP-Device1",od.getDSP(1));
		config->sync();
	}
}

