/***************************************************************************
                          kssdialogs.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __KSS_DIALOG__
#define __KSS_DIALOG__

#include <kapp.h>

#include <qdialog.h>
#include <qcombo.h>
#include <qbutton.h>
#include <qchkbox.h>
#include <qpushbt.h>
#include <qlined.h> 
#include <qvalidator.h> 
#include <qradiobt.h> 
#include <qframe.h> 
#include <qlabel.h> 
#include <qstring.h> 
#include <qapp.h> 

#include <kcolorbtn.h> 
#include <kconfig.h> 
#include <klocale.h> 
#include <kprogress.h> 
#include <kcombo.h>

#include "kgraphedit.h"

class	namedialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*line;

public:
	namedialog(QWidget *parent,const char *name);
	~namedialog();

	QString		getName();

};

class	kssdialog : public QDialog
{
Q_OBJECT

private:
	QPushButton	*ok,*cancel,*save,*del;
	//KCombo		*list;
	QComboBox	*list;

protected:
	QString		profile;
	QStrList	*strlist;

public:
	kssdialog(QWidget *parent,const char *name,QString pf);
	~kssdialog();

	void		resize(int w,int h);
	void		addEntry(QString);

protected:
	QString		getName(char *);

public slots:
	virtual void	loadProfile(const char*) = 0;
	virtual void	saveProfile(const char*) = 0;
	virtual void	deleteProfile() = 0;

	void		saveProfileInt();

signals:
	void		activated(const char*);

};

class	envdialog : public kssdialog
{
Q_OBJECT

protected:
	KGraphEdit	*kge;

public:
	envdialog(QWidget *parent,const char *name);
	~envdialog();

	QArray<double>	getPoints();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	distdialog : public kssdialog
{
Q_OBJECT

protected:
	KGraphEdit	*kge;
	QCheckBox	*qcb;

public:
	distdialog(QWidget *parent,const char *name);
	~distdialog();

	QArray<double>	getPoints();
	int		symmetric();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	dphpdialog : public kssdialog
{
Q_OBJECT

protected:
	double			r,c;
	QLineEdit		*rline,*cline;
	QLabel			*rlabel,*clabel;
	QDoubleValidator	*dblv;

public:
	dphpdialog(QWidget *parent,const char *name);
	~dphpdialog();

	double		getR();
	double		getC();


public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	blurdialog : public kssdialog
{
Q_OBJECT

protected:
	double			size;
	QLineEdit		*sizeline;
	QLabel			*sizelabel;
	QDoubleValidator	*dblv;

public:
	blurdialog(QWidget *parent,const char *name);
	~blurdialog();

	double		getSize();


public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	voldialog : public kssdialog
{
Q_OBJECT

protected:
	double			vol;
	QLineEdit		*volline;
	QLabel			*vollabel;
	QDoubleValidator	*dblv;

public:
	voldialog(QWidget *parent,const char *name);
	~voldialog();

	double		getVol();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	multiplierdialog : public kssdialog
{
Q_OBJECT

protected:
	double						m_multiplier;
	QLineEdit					*m_multline;
	QLabel						*m_multlabel;
	QDoubleValidator	*m_dblv;

public:
	multiplierdialog(QString title,double defaultvalue = 1,QWidget *parent = 0,const char *name = 0);
	~multiplierdialog();

	double		getMultiplier();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	timedialog : public kssdialog
{
Q_OBJECT

protected:
	double			sec;
	QLineEdit		*secline;
	QLabel			*seclabel;
	QDoubleValidator	*dblv;

public:
	timedialog(QWidget *parent,const char *name);
	~timedialog();

	double		getSeconds();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	echodialog : public kssdialog
{
Q_OBJECT

protected:
	double			vol,delay,release;
	QLineEdit		*volline,*delayline,*releaseline;
	QLabel			*vollabel,*delaylabel,*releaselabel;
	QDoubleValidator	*volv,*delayv,*releasev;

public:
	echodialog(QWidget *parent,const char *name);
	~echodialog();

	double		getDelay();
	double		getVolume();
	double		getRelease();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	fuzzdialog : public kssdialog
{
Q_OBJECT

protected:
	double			vol,cut;
	int			side;
	QLineEdit		*volline,*cutline,*sideline;
	QLabel			*vollabel,*cutlabel,*sidelabel;
	QDoubleValidator	*volv,*cutv,*sidev;

public:
	fuzzdialog(QWidget *parent,const char *name);
	~fuzzdialog();

	double		getCut();
	double		getVolume();
	int		getSide();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	formatdialog : public kssdialog
{
Q_OBJECT

protected:
	int			samplerate,type,nchannel;
	QRadioButton		*I8,*I16,*I32,*FL,*DB;
	QFrame			*typeframe;
	QLabel			*sampleratelabel;
	QLineEdit		*samplerateline;
	QDoubleValidator	*samplerateval;

private slots:
	void		type8Clicked();
	void		type16Clicked();
	void		type32Clicked();
	void		typeFLClicked();
	void		typeDBClicked();

public slots:

	void		loadProfile(const char*);
	void		saveProfile(const char*);
	void		deleteProfile();

public:
	formatdialog(QWidget *parent,const char *name,int,int);
	~formatdialog();

	uint		getSampleRate();
	uint		getType();
};

class	newdialog : public kssdialog
{
Q_OBJECT

protected:
	int			samplerate,type,nchannel;
	QRadioButton		*I8,*I16,*I32,*FL,*DB;
	QFrame			*typeframe;
	QLabel			*sampleratelabel,*nchannellabel;
	QLineEdit		*samplerateline,*nchannelline;
	QDoubleValidator	*samplerateval,*nchannelval;

private slots:
	void		type8Clicked();
	void		type16Clicked();
	void		type32Clicked();
	void		typeFLClicked();
	void		typeDBClicked();

public:
	newdialog(QWidget *parent,const char *name,uint,uint,uint);
	~newdialog();

	uint		getSampleRate();
	uint		getType();
	uint		getNChannel();

public slots:

	void		loadProfile(const char*);
	void		saveProfile(const char*);
	void		deleteProfile();

};


class	colordialog : public kssdialog
{
Q_OBJECT

protected:
	KColorButton		*colorbt[12];
	QLabel			*colorlabel[12];
public:
	colordialog(QWidget *parent,const char *name,QColor *q[11]);
	~colordialog();

	void		getColors(QColor *c[11]);

public slots:

	void		loadProfile(const char*);
	void		saveProfile(const char*);
	void		deleteProfile();

};

class	noisegatedialog : public kssdialog
{
Q_OBJECT

protected:
	double			vol;
	QLineEdit		*volline;
	QLabel			*vollabel;
	QDoubleValidator	*dblv;

public:
	noisegatedialog(QWidget *parent,const char *name);
	~noisegatedialog();

	double		getTreshhold();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};

class	compressdialog : public kssdialog
{
Q_OBJECT

protected:
	double			level;
	QLineEdit		*levelline;
	QLabel			*levellabel;
	QDoubleValidator	*dblv;

public:
	compressdialog(QWidget *parent,const char *name);
	~compressdialog();

	double		getLevel();

public slots:

	virtual void	loadProfile(const char*);
	virtual void	saveProfile(const char*);
	virtual void	deleteProfile();

};


// ******************************************************************************


class progressdialog : public QDialog
{
Q_OBJECT

protected:
	KProgress	*progress;
	QLabel		*label;
	QPushButton	*cancel;
	QApplication	*app;

public:
	progressdialog(QApplication*,QWidget *parent,const char *name);
	~progressdialog();

	void		setText(QString);
	void		setProgress(double);
	void		sync();

};

class optiondialog : public QDialog
{
Q_OBJECT

private:
	QLabel		*dsplabel[4];
	QLineEdit	*dspline[4];
	QPushButton	*ok,*cancel;

public:
	optiondialog(QWidget *parent,const char *name);
	~optiondialog();

	QString		getDSP(int n = 0);
	void		setDSP(QString,int n = 0);

public slots:

	void		okPressed();
};

#endif



