/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998-2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#ifndef DOCKWIDGET_H
#define DOCKWIDGET_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qpopmenu.h>	// <qpopupmenu.h>
#include <qpixmap.h>
#include <qevent.h>


class DockWidget : public QWidget
{
	Q_OBJECT

public:
	DockWidget( const char * name = 0 );
	~DockWidget();

	bool isDocked();

	void markMode( int mode );
	void markBypass( bool on );
	void markVisible( bool visible );


protected:
	virtual void paintEvent( QPaintEvent * );
	virtual void mousePressEvent( QMouseEvent * e );

private slots:
	void menuDBPL();
	void menu3DPhon();
	void menuThrough();
	void menuNoise();
	void menuBypass();
	void menuVisible();
	void menuQuit();

public slots:
	void dock();
	void undock();

signals:
	void dock_mode( int );
	void dock_bypass( bool );
	void dock_toggle_visible();
	void dock_quit();

private:
	bool docked;
	int modeID[4], bypassID, toggleID;
	QPopupMenu * dock_menu;
	QPixmap pix;
};

#endif // DOCKWIDGET_H
