/* $Id: kstereoOptionen.cc,v 1.5 1999/05/05 20:49:57 philipp Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlabel.h>
#include <kapp.h>
#include "kstereoOptionen.moc"

kstereoOptionen::kstereoOptionen(QWidget* parent, StereoView* s)
  : QTabDialog(parent, "optionsDialog", true) {
  sview = s;
  QLabel* label;
  QWidget* blech = new QWidget();

  KConfig* conf = kapp->getConfig();
  conf->setGroup("KStereo");

  dspDevice = new QLineEdit(blech);
  dspDevice->setText(conf->readEntry("DSP_Device", "/dev/dsp"));
  dspDevice->resize(100, dspDevice->height());
  dspDevice->move(140,10);

  label = new QLabel(dspDevice, i18n("DSP device:"), blech);
  label->adjustSize();
  label->move(10, 18);

  samplingRate = new KIntegerLine(blech);
  samplingRate->setValue(conf->readNumEntry("SamplingRate"));
  samplingRate->move(140, 50);

  label = new QLabel(samplingRate, i18n("Sampling rate:"), blech);
  label->adjustSize();
  label->move(10, 58);

  interval = new KIntegerLine(blech);
  interval->setValue(conf->readNumEntry("Interval"));
  interval->move(140, 90);

  label = new QLabel(interval, i18n("Update interval:"), blech);
  label->adjustSize();
  label->move(10, 98);

  buffer = new KIntegerLine(blech);
  buffer->setValue(conf->readNumEntry("LogPoints"));
  buffer->move(140, 130);

  label = new QLabel(buffer, i18n("Buffer size:"), blech);
  label->adjustSize();
  label->move(10, 138);

  addTab(blech, i18n("Data Acquisition"));

  resize(300, 250);
  setCancelButton(i18n("Cancel"));
  setOKButton(i18n("OK"));
  setApplyButton(i18n("Apply"));
  setCaption(i18n("Options"));
  connect(this, SIGNAL(applyButtonPressed()), this, SLOT(applyChanges()));
  connect(this, SIGNAL(OKButtonPressed()), this, SLOT(commitChanges()));
  connect(this, SIGNAL(cancelButtonPressed()), this, SLOT(cancelChanges()));
}


void kstereoOptionen::applyChanges() {
  KConfig* conf = kapp->getConfig();
  if (!sview->setzeDevice(dspDevice->text()))
    conf->writeEntry("DSP_Device", dspDevice->text());
  if (!sview->setzeRate(samplingRate->value()))
    conf->writeEntry("SamplingRate", samplingRate->value());
  sview->setzeIntervall(interval->value());
  conf->writeEntry("Interval", interval->value());
  sview->setzePunktLog(buffer->value());
  conf->writeEntry("LogPoints", buffer->value());
}

void kstereoOptionen::commitChanges() {
  applyChanges();
  kapp->getConfig()->sync();
}
