/* $Id: stereoscope.cc,v 1.5 1999/05/05 20:35:40 philipp Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <qpainter.h>

#include "stereoscope.moc"


StereoScope::StereoScope(QWidget* parent, const char* name, unsigned
			 int l)
  : QFrame(parent, name) {
  logpunkte = l;
  x = new int [logpunkte];
  memset(x, 0, logpunkte * sizeof(int));
  y = new int [logpunkte];
  memset(x, 0, logpunkte * sizeof(int));
  punktzeiger = 0;

  schwarz = QColor(0, 0, 0);
  rot = QColor(255, 0, 0);
  grau = QColor(128, 128, 128);

  setFixedSize(256, 256);
  setBackgroundColor(schwarz);
  setFrameStyle(WinPanel | Sunken);
  setLineWidth(2);
}

StereoScope::~StereoScope() {
  delete [] x;
  delete [] y;
}

void StereoScope::setzePunktLog(unsigned int l) {
  logpunkte = l;
  delete [] x;
  x = new int [logpunkte];
  memset(x, 0, logpunkte * sizeof(int));
  delete [] y;
  y = new int [logpunkte];
  memset(x, 0, logpunkte * sizeof(int));
  punktzeiger = 0;
}

void StereoScope::neueDaten(const unsigned char* buffer,
			    unsigned int bufsize) {
  unsigned int punkte = bufsize / 2;
  QPainter qp;
  if (qp.begin(this)) {
    qp.translate(128, 128);
    qp.setBackgroundColor(schwarz);
    qp.setPen(schwarz);
    for (unsigned int i = 0; i < punkte; i++) {
      unsigned int j = (i + punktzeiger) % logpunkte;
      bool b = abs(x[j]) == abs(y[j]);
      if (b) qp.setPen(grau);
      qp.drawPoint(x[j], y[j]);
      if (b) qp.setPen(schwarz);
    }
    
    qp.setPen(rot);
    for (unsigned int i = 0; i < punkte; i++) {
      unsigned int j = (i + punktzeiger) % logpunkte;
      int r = (int) buffer[i * 2] - 128;
      int l = (int) buffer[i * 2 + 1] - 128;
      x[j] = (l - r) >> 1;
      y[j] = (-r - l) >> 1;
      qp.drawPoint(x[j], y[j]);
    }
    punktzeiger = (punktzeiger + punkte) % logpunkte;
    
    qp.end();
  }
}

void StereoScope::paintEvent(QPaintEvent* qpevt) {
  QPainter qp;
  if (qp.begin(this)) {
    int i;
    drawFrame(&qp);
    qp.translate(128, 128);
    qp.setPen(grau);
    for (i = 0; i <= 70; i++) {
      qp.drawPoint(i, i);
      qp.drawPoint(-i, i);
      qp.drawPoint(i, -i);
      qp.drawPoint(-i, -i);
    }
    qp.drawText(70, -86, 16, 16, AlignHCenter |
		AlignVCenter, "R");
    qp.drawText(-86, -86, 16, 16, AlignHCenter |
		AlignVCenter, "L");
    qp.setPen(rot);
    for (i = 1; i < logpunkte; i++)
      qp.drawPoint(x[i], y[i]);
    qp.end();
  }
}
