	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "execdlg.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <kbuttonbox.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <kapp.h>
#include <qlined.h>

static void min_size(QWidget *w) {
  w->setMinimumSize(w->sizeHint());
} 

ExecDlg::ExecDlg(QWidget *parent, KSynthesizer *Synthesizer) :QDialog(parent,"X", TRUE)
{
	this->Synthesizer = Synthesizer;

	setCaption("SoundScape Module Execution");

	QVBoxLayout *mainlayout = new QVBoxLayout(this);

// caption label: "Synthesis running..."

	mainlayout->addSpacing(5);
	QLabel *captionlabel = new QLabel(this);
	QFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(QString(" ")+i18n("Synthesis running...")+QString(" "));
	captionlabel->setAlignment(AlignCenter);
	min_size(captionlabel);
	mainlayout->addWidget(captionlabel);

// hruler

	mainlayout->addSpacing(5);
	QFrame *ruler = new QFrame(this);
	ruler->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	ruler->setMinimumSize(50,2);
	mainlayout->addWidget(ruler);

	mainlayout->addSpacing(5);

// buttons

	QHBoxLayout *buttonlayout = new QHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	QButton *helpbutton = bbox->addButton(i18n("Help"));

	bbox->addStretch(1);

	QButton *okbutton = bbox->addButton(i18n("Okay"));
	connect( okbutton, SIGNAL( clicked() ), SLOT(stop() ) );
	connect( okbutton, SIGNAL( clicked() ), SLOT(accept() ) );

	bbox->layout();
	//min_size(bbox);

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	mainlayout->freeze();

	this->Synthesizer = Synthesizer;
	Synthesizer->Start(128);
};

void ExecDlg::stop()
{
	Synthesizer->Stop();
}
