	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synth.h"
#include <stdio.h>

int main( int argc, char **argv )
{
	if(argc != 2)
	{
		fprintf(stderr,"usage: %s <description_file>\n",argv[0]);
		exit(0);
	}

// ---- connect to synthesizer

	CORBA::ORB_var orb = CORBA::ORB_init( argc, argv, "mico-local-orb" );
	CORBA::BOA_var boa = orb->BOA_init( argc, argv, "mico-local-boa" );

	CORBA::Object_var obj =
		orb->bind ("IDL:KSynthesizer:1.0", "inet:localhost:8888");
	if (CORBA::is_nil (obj)) {
		fprintf(stderr,"no synthesizer object found, start synth_server\n");
		exit(1);
	}

	KSynthesizer_var Synthesizer = KSynthesizer::_narrow (obj);

// ---- now Synthesizer is a valid KSynthesizer ;)

	char buffer[1024];

	FILE *infile = fopen(argv[1],"r");
	if(!infile)
	{
		fprintf(stderr,"Can't open file '%s'.\n",infile);
		exit(1);
	}

	Synthesizer->Execute("clear");

	while(fgets(buffer,1024,infile))
	{
		fprintf(stderr,"LINE %s\n",buffer);
		Synthesizer->Execute(buffer);
	}

	fclose(infile);

	char *errors;
	Synthesizer->SyntaxCheck(errors);

	Synthesizer->Start(512);

	printf(" << synthesis should be running now, hit return to stop >> \n");
	getchar();

	Synthesizer->Stop();

	return 0;
}
