	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "utils.h"
#include <sys/time.h>

int get_byteorder()
{
	union {
		long l;
		char c[4];
	} test;
	test.l = 1;
	if(test.c[3] == 1 && (test.c[2] == test.c[1] == test.c[0] == 0) )
		return(ORDER_BIGENDIAN);

	if(test.c[3] == 0 && (test.c[2] == test.c[1] == test.c[0] == 1) )
		return(ORDER_LITTLEENDIAN);

	return(ORDER_UNKNOWN);
}

float benchmark(int what)
{
	static struct timeval start,stop;

	if(what == BENCH_BEGIN)
	{
		gettimeofday(&start,NULL);
		return(0);
	}
	if(what == BENCH_END)
	{
		float diff;
		gettimeofday(&stop,NULL);
		diff = (stop.tv_sec-start.tv_sec);
		diff += (float)(stop.tv_usec-start.tv_usec)/1000000;
		return(diff);
	}
}
