/***************************************************************************
                          ktuner.h  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// ktuner.h
// ktuner v0.1, by Carl van Schaik
// e-mail carl@leg.uct.ac.za

#ifndef KTUNER_H
#define KTUNER_H

#include "hardware.h"
#include "conf.h"
#include "options.h"
#include "timer.h"
#include "alarm.h"
#include "images.h"
#include "docking.h"

#include <qapp.h>
#include <qpushbt.h>
#include <qpixmap.h> 
#include <qslider.h>
#include <qcombo.h>
#include <qlcdnum.h>
#include <qlabel.h>
//#include <kmenubar.h>

//This is where we initialise the cardDevice
/* radioCard  *cardDev; */
/* configFile *config; */
/* char       *channelName[100]; */
/* int        *channelFreq, numChannels; */

class DispBox : public QWidget
{
 Q_OBJECT
 public:
  DispBox (configFile* cf, QWidget *parent=0, const char *name=0);
  void sleep(int);

 public slots:
  void setFreq(int);
  void setVol(int);
  void toggleMute();
  void toggleOn();
  void toggleOff();
  void toggleAlarm();

 private:
  int Mute,
      alarm,
      timer;
  QLCDNumber *chNumInd,
             *volInd,
             *freqNumInd;

  QLabel     *stNameInd,
             *stLockInd,
             *sleepInd,
             *alarmInd,
             *stInd,
             *mhzInd,
             *muteInd;
  QWidget    *Off,*P;
  QPixmap    bgPix,cRPix;

  void timerEvent( QTimerEvent * );
};

class Presets : public QWidget
{
Q_OBJECT
 public:
  Presets(configFile* cf, QWidget *parent=0, const char *name=0);
  void reset();

 signals:
  void sendFreq(int);
  void sendVol(int);
  void optionsUpdate();

 public slots:
  void setFreq0();
  void setFreq1();
  void setFreq2();
  void setFreq3();
  void setFreq4();
  void setFreq5();
  void setFreq6();
  void setFreq7();
  void setFreq8();
  void volUp();
  void volDown();

 private slots:
  void setFreqMore(int);
  void editChannel();
  void addChannel();
  void deleteChannel();
  void editDone();

 private:
  QPushButton *ch[9];
  QComboBox   *moreBox;
  int         Selected;
  QPushButton *Commands[3],
              *volUpBut,
              *volDownBut;
  configFile  *conf;
  presetEdit  *editBox;
  presetAdd   *addBox;
};

class Tuning : public QWidget
{
 Q_OBJECT
 public:
  Tuning(configFile* cf, QWidget *parent=0, const char *name=0 );
 
 signals:
  void freqChanged(int);

 public slots:
  void freqSet(int);
  void freqInc();
  void freqDec();

 private slots:
  void scanDwnSlot(); // Scans Down for channels depending on input
  void scanUpSlot();  // Scans Up for channels depending on input
 //  void freqChg(int);
  void freqSetBar(int);

 private:
  int Busy,noTwice,timer,scanState;

  void freqChg(int);

  int currentFreq;

  QPushButton *scanDwn,
              *scanUp,
              *fineDwn,
              *fineUp;
  QSlider     *tuneBar;

  void timerEvent( QTimerEvent * );

};

class Controls : public QWidget
{
Q_OBJECT
 public:
  Controls( QWidget *parent=0, const char *name=0);

 signals:
  void mutePressed();
  void onPressed();
  void offPressed();
  void resizePressed();

 private slots:
  void toggleResize();
  void toggleOff();
  void toggleOn();
  void toggleMute();

 private:
  QPushButton *but[5];
  int sizeState;
  QWidget *P;
};

class Misc : public QWidget
{
Q_OBJECT
 public:
  Misc( QWidget *parent=0, const char *name=0);

 signals:
  void sleepToggle();
  void optionsToggled();
  void alarmToggled();

 private slots:
  void sleepPushed();
  void optionsPushed();
  void alarmPushed();

 private:
  QPushButton *but[3];
};


// The Main Window Widget
class Radio : public QWidget
{
Q_OBJECT
 public:
  Radio (configFile*, radioCard *rc, QWidget *parent=0, const char *name=0);

 private slots:
  void sleepToggle();
  void timerUp();
  void doUpdate();
  void doUpdate2();
  void toggleState();
  void floatPushed(int);

 protected:
  void keyPressEvent( QKeyEvent* );

 private:
  void closeEvent( QCloseEvent *e );

  DispBox   *Disp;
  Presets   *Chans;
  Tuning    *Tune;
  Controls  *Buts;
  Misc      *misc;
  optionBox *optBox;
  //KMenuBar  *mainmenu;

  sleepTimer *Timer;
  alarmClock *alarm;
  int sleepState;
  //int sizeState;

  configFile* config;
  int optionsOn,CtrlPress;
};

#endif // KTUNER_H
