// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/DirScan.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:35 $
// $State: Exp $
// **************************************************************

#ifndef DirScan_h
#define DirScan_h

#include <string>
#include <dirent.h>

// struct DIR;
struct dirent;

class DirScan
{
    string rootdir_name;

    DIR *current_dir;

    struct dirent *current_entry;

    DirScan *current_sub_dir;
    
    string current_subdir_name;

public:
    /**
     * Start scanning a dir and all its subdirectories. You must
     * call @ref #toNext to switch to the first entry.
     * @param rootdir_name Path of the dir to be scanned.
     */
    DirScan(string rootdir_name);

    /**
     * Free internal data.
     */
    ~DirScan();

    /**
     * Get the Pathname of the currently scanned directory relative
     * to the rootdir_name ( see @ref #DirScan ).
     */
    string relativeDirPath() const;

    /**
     * Gets the filename of the current file. May be used to open
     * the file with fopen(), because is the full path to the file
     * relative to rootdir_name;
     */
    string fullFilename() const;

    /**
     * Switch to the next dir entry. Returns true, if there was
     * a next entry.
     */
    bool toNext();

private:
    /**
     * Filename of the current entry without any path component.
     */
    string fileName() const;

    bool isDirectory(string filename) const;
};


#endif // DirScan_h

