// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/GlobalCache.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:35 $
// $State: Exp $
// **************************************************************
// -*- c++ -*-

#include "GlobalCache.h"

#ifdef DEBUG
#include <iostream.h>
#endif

void GlobalCache::enter(GlobalCacheEntry *gce)
{
  lists[gce->preserved ? preserved : normal].addFirst(gce);
  current_size += gce->memory_size;
#ifdef DEBUG
    cout << "entry entered, size = " << gce->memory_size 
         << ", current_size is now " << current_size << endl;
#endif
  checkSize(); // tries to free memory, if cache is bigger than allowed
}


bool GlobalCache::freeOneEntry(list_type lt)
{
    DLListNode *to_delete = lists[lt].getLast();
    while (!lists[lt].isEndOfList(to_delete)) {
	if (!((GlobalCacheEntry *)to_delete)->isReferenced()) { // found!
	    current_size -= ((GlobalCacheEntry *)to_delete)->memory_size;
#ifdef DEBUG
	    cout << "entry size " << ((GlobalCacheEntry *)to_delete)->memory_size 
		 << " deleted. Size now " << current_size << endl;
#endif
	    delete to_delete;
	    return true;
	}
	else to_delete = to_delete->getNext();
    }
    return false;
}

