// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Metainfo.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

#ifndef Metainfo_h
#define Metainfo_h

#include "BasicTypes.h"

class Metainfo
{
    enum type { SAMPINT=0x01,  DURATION=0x02,
		CUT_FROM=0x04, CUT_TO=0x8, NCHANNELS=0x10 };
    
    Number         sampint;
    Number         duration;
    long           cut_from;
    long           cut_to;
    unsigned short nchannels;
    unsigned short containsbits;
    
public:
    Metainfo() : containsbits(0) {};

    bool containsSamplingInterval() const { return 0 != (containsbits & SAMPINT); };
    bool containsDuration()         const { return 0 != (containsbits & DURATION); };
    bool containsCutFrom()          const { return 0 != (containsbits & CUT_FROM); };
    bool containsCutTo()            const { return 0 != (containsbits & CUT_TO); };
    bool containsNumberOfChannels() const { return 0 != (containsbits & NCHANNELS); };
    
    void setSamplingInterval(Seconds s=0)        { sampint = s;   containsbits |= SAMPINT;};
    void setDuration(Number d=0)                 { duration = d;  containsbits |= DURATION; };
    void setCutFrom(long f=0)                    { cut_from = f;  containsbits |= CUT_FROM; };
    void setCutTo(long t=0)                      { cut_to = t;    containsbits |= CUT_TO; };
    void setNumberOfChannels(unsigned short n=0) { nchannels = n; containsbits |= NCHANNELS; };
    
    Seconds        getSamplingInterval()   const { return sampint; };
    Number         getDuration()           const { return duration; };
    long           getCutFrom()            const { return cut_from; };
    long           getCutTo()              const { return cut_to; };
    unsigned short getNumberOfChannels()   const { return nchannels; };
    
    void clearSamplingInterval()                 { containsbits &= ~SAMPINT; };
    void clearDuration()                         { containsbits &= ~DURATION; };
    void clearCutFrom()                          { containsbits &= ~CUT_FROM; };
    void clearCutTo()                            { containsbits &= ~CUT_TO; };
    void clearNumberOfChannels()                 { containsbits &= ~NCHANNELS; };
    void clear()                                 { containsbits = 0; };
};

#endif // Metainfo_h
