// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Module.h,v $
// $Revision: 1.2 $
// $Date: 1999/05/13 20:16:01 $
// $State: Exp $
// **************************************************************

#ifndef Module_h
#define Module_h

#include <string>

#include "DLList.h"
#include "maxnumbers.h"
#include "BasicTypes.h"

class SamplingConfig;
class Connector;
class ModuleErrorReport;
class OutputModuleFile;
class InputModuleFile;

class Module : public DLListNode // for list in MacroModule
{
    unsigned short number_connectors;

    Connector *a_connector[MAX_NUMBER_CONNECTORS];

    /**
     * During loading and saving the modules are asigned IDs to have a
     * reference point for the wires.
     */
    int       id; // used during loading and saving!

    ModuleErrorReport *error_report;

    /**
     * When this Module is Part of an EMBEDDED MacroModule: Defines
     * whether this Module should be visible in the outlook of that
     * MacroModule.
     */
    bool is_visible;

    /**
     * Used by MacroModuleEditor to store grid x position of ModuleLook.
     */
    short grid_left;

    /**
     * Used by MacroModuleEditor to store grid y position of ModuleLook.
     */
    short grid_top;

    /**
     * Flag, that is used to define a subset of Modules. Funktion
     * @ref #saveToFile can be told only to save this subset.
     */
    bool selected;

protected:

    /**
     * Initializes internal data structures. 
     */
    Module();

    /**
     * Adds a Slot or a Signal to the Module. The new Connector must have
     * a name unique within the Module. 
     * @return not empty if an error occured. Describes the error.
     */
    string addConnector(Connector *c);

    /**
     * Removes a Connector.
     */
    void removeConnector(Connector *c);

public:
    virtual ~Module();

    virtual string getName() const = 0;

    virtual void setID(int i)                   { id=i; };

    virtual int  getID() const                  { return id; };

    virtual string toString() const             { return ""; };

    /**
     * Gives the module a chance to write data directly into 
     * an open Module file. This is needed, if the parameter of
     * the module is too complex to be written into a simple
     * String with @ref #toString. The most important such Module
     * is @ref MacroModule.
     */
    virtual void writeToFile(OutputModuleFile& /*modulefile*/) { };

    /**
     * Gives the module a chance to read data directly from
     * an open Module file. This is needed, if the parameter
     * of the module is too complex to be read from a simple
     * String in the Constructor. The most important such Module
     * is @ref MacroModule.
     * @return false, if a read or syntax error in the file occured.
     */
    virtual bool readFromFile(InputModuleFile& /*modulefile*/) { return  true; };

    // Look

    void moveTo(short left, short top);

    short gridLeft() const;
    
    short gridTop() const;

    bool isVisible() const;

    void setVisibility(bool visible);

    /**
     * Returns true, if this Module is selected. See @ref selected.
     */
    bool isSelected() const;
    
    /**
     * Selects or deselects this module. See @ref selected.
     */
    void select(bool yesno);

    // Executing

    virtual bool isExecutable() const           { return false; };
    virtual void prepareForExecution(const SamplingConfig *) { }; // e.g. open output file. 
    virtual bool executeBlock(long, long)       { return false; }; // return: want to continue;
    virtual void finishExecution()              { };               // e.g. close output file.

    /**
     * Realtime output devices must not write out data faster than real time.
     * A Module should return true to this funktion, if it is not able to play
     * further samples without disturbing realtime characteristics or loosing
     * samples due to lack of buffer space.
     */
    virtual bool mustWait()                     { return false; };

    // Error reporting

    void reportError(const char *title, const char *text);
    ModuleErrorReport *getErrorReport();
    
    // Access to Connectors

    Connector * const *connectorTable() const;
    unsigned short numberConnectors() const;
    Connector *connectorNamed(string name) const;
    Connector *connectorNumber(unsigned short id) const { return a_connector[id]; };
    string nameOfConnector(unsigned short id) const;
};


#endif // Module_h
