// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Slot.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************

#ifndef Slot_h
#define Slot_h

#include "Connector.h"

class Signal;
class PreparedSignal;
class Metainfo;
class Parameterset;

class Slot : public Connector
{
    /**
     * Number of the color a wire should be painted in that
     * connects this slot. This is used by the GUI only. It has
     * no meaning for the command line player. The command line
     * player has to be compilable without ANY Qt or KDE file.
     */
    short wirecolor;

    /**
     * @ref Signal this Slot is wired to. 0, if this slot is not
     * wired to a Signal. Remark, that a Signal can be wired to
     * many Slots, but a Slot to only one Signal.
     */
    Signal *wired_to;

    /**
     * Is true, if this Slot is a parameter Slot. A parameter slot will
     * be dynamically wired whenever a Signal of the same Module is
     * evaluated. If is_parameter == true, then wired_to must be 0.
     */
    bool is_parameter;

protected:
    /**
     * Holds the Signal that is currently beeing computed. This
     * is to answer questions for parameter Signals during a call
     * of getPrepared...Signal() to the Signal the Slot is connected
     * to.
     */
    Signal *currently_being_computed;

public:
    /**
     * Creates a new unconnected Slot.
     * @param type Type of the Slot. SOUND_TYPE, NUMBER_TYPE, TEXT_TYPE, ...
     * @param name Name of this Slot. Names of Slots must be unique within a module.
     * @param wirecolor see @ref #wirecolor.
     */
    Slot(SignalType type, string name, string description, Module *m, short wirecolor);
    
    virtual ~Slot(); // base class must have virtual destructor

    bool isSlot() const { return true; };

    /**
     * Gets the Signal this slot is connected to. It the slot is wired to a
     * Signal, that Signal is the connection. If this Slot is a parameter Slot
     * and thus carried by a Signal, that Signal is asked to for the correspondig
     * parameter Signal.
     * @param currently_computing The Signal that is currently being computed and for
     * the computation of which the answer of this call is needed.
     * @return The Signal this Slot is connected to. Returns 0 if this Slot is not
     * connected. TODO: What if its carried but no parameter Signal is provided?
     */
    Signal *getSignal(Signal *currently_beeing_computed);

    /**
     * A Signal asks this Slot to provide a parameter signal. This happens while 
     * this Slot is in the call <some_signal> -> getSignal(this) and means "To answer
     * your demand of calculating the Signal I first need some parameter
     * Signal from you!". The default behavior is to give through the call to the
     * Signal @ref #currently_beeing_computed, if available. A module that wants
     * to provide a parameter Signal must override this function and redirect the
     * call to a @ref Slot#getSignal to one of its Slots.
     * @param name Name of the parameter signal. 
     */
    virtual Signal *getParameterSignal(const char *name);

    /**
     * Wires this slot to a signal. Overrides the effect of a former call to @ref #carryOn.
     * Signal *s Signal this slot should be wired to. The signal must be of the same SignalType
     * as the this slot.
     */
    void wireTo(Signal *s);

    /**
     * Makes this Slot a parameter Slot. Whenever a @ref Signal of the same Module
     * is evaluated, it in return asks the caller to provide a parameter Signal for
     * this slot. A Module may have an arbitrary number of parameter Slots.
     * Overrides the effect of a former call to @ref #wireTo.
     */
    void makeParameter();

    /**
     * Undoes the effect of @ref #wireTo or @ref #defineToBeParameter, resp. It returns 
     * the slot to its initial i.e. unwired state.
     */
    void disconnect();

    /**
     * Return true, if this slot is wired to or parameter.
     */
    bool isConnected() const;

    /**
     * Returns true, if this slot is a parameter Slot.
     */
    bool isParameter() const;

    /**
     * Returns the wire color-number of this Slot. For the
     * meaning of the color numbers see @ref Wirecell.
     */
    short getWireColor() const;

    /**
     * Tries to find a Signal, that this Slot is wired to or that is a parameter
     * Signal and gets the @ref PreparedSignal from this Signal. The answer will be
     * of Type PreparedSoundSignal *, PreparedNumberSignal *, PreparedTextSignal *,.. depending
     * on the type of this Slot.
     */
    PreparedSignal *getPreparedSignal(Signal *cbc, Metainfo *mi=0, const Parameterset *ps=0);
};

#endif // Slot_h
