// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/SoundCacheEntry.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************
// -*- c++ -*-

#ifndef SoundCacheEntry_h
#define SoundCacheEntry_h

#include "SoundCacheKey.h"
#include "AVLTree.h"
#include "GlobalCache.h"
#include "SoundPortion.h"

// A SoundCacheEntry is in the first place an array of sound data. It is stored in
// the global cache (which checks memory consumption and frees memory, if neccessary)
// and in the sound cache index of a CachedSoundSignal. This index is realized as
// an AVLTree. A SoundCacheEntry is referenced to by SoundPortions and therefore
// implements the interface SharedStore.

class SoundCacheEntry : 
  private AVLTreeNode, 
  public  GlobalCacheEntry, 
  private SharedStore
{
  friend class CachedSoundSignal;
  Number *data;             // the actual cache
  Number *start_of_samples; // actually used data. Points somewhere in data[].
  SoundCacheKey key;        // find the entry by end_time, sampl_interval, metainfo.
  long start_time;          // start time of the used data
  long reference_counter;   // for GlobalCacheEntry and for SharedStore
public:
  SoundCacheEntry(Number *d, long n, bool preserved, Number *ss, 
		  long stime, long numsamp, const Parameterset& parset) : 
    data(d), GlobalCacheEntry(sizeof(Number) * n + sizeof(*this), preserved), 
    start_of_samples(ss), start_time(stime), 
    key(stime + numsamp, parset), reference_counter(0) {};
  ~SoundCacheEntry()        { delete data; };
  long getStartTime() const { return start_time; };
  long getEndTime()   const { return key.time; };
  Number *getSamples()      { return start_of_samples; };
  void reference()          { reference_counter++; }; // for SharedStore
  void unreference()        { reference_counter--; }; // for SharedStore
protected: 
  bool isReferenced() const { return reference_counter > 0; };
  int comparedTo(AVLTreeNode *n) const  // for AVLTreeNode
    { return key.comparedTo(((SoundCacheEntry *)n)->key); };
  int comparedTo(void *n) const         // for AVLTreeNode
    { return key.comparedTo(*(SoundCacheKey *)n); };
};


#endif // SoundCacheEntry_h
