// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESDraggingRectangle.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:34 $
// $State: Exp $
// **************************************************************

#include "ESDraggingRectangle.h"
#include "ESNothing.h"
#include "MacroModuleLook.h"

ESDraggingRectangle::ESDraggingRectangle(MacroModuleLook *mml, QPoint start_position)
    : EditorState(mml)
    , start_position(start_position)
    , rectangle_position(start_position)
{
}

void ESDraggingRectangle::enter()
{
    draw();
}

void ESDraggingRectangle::leave()
{
    draw();
}


EditorState *ESDraggingRectangle::leftButtonReleased(const QMouseEvent *)
{
    return new ESNothing(mml);
}


EditorState *ESDraggingRectangle::mouseMoved(const QMouseEvent *event)
{
    draw(); // erase old rect
    QRect old_rect = QRect(start_position, rectangle_position).normalize();
    rectangle_position = event->pos();
    QRect new_rect = QRect(start_position, rectangle_position).normalize();
    mml->rectangularSelection(old_rect, new_rect);
    draw(); // draw new rect
    return this;
}


void ESDraggingRectangle::paintEvent(QPainter& p, const QRect& update_rect)
{
    if (QRect(start_position, rectangle_position).normalize().intersects(update_rect)) draw(p);
}

void ESDraggingRectangle::draw() const
{
    QPainter *p = new QPainter();
    p->begin(mml->widget());
    draw(*p);
    p->end();
    delete p;
}


void ESDraggingRectangle::draw(QPainter& p) const
{
    QRect rect(start_position, rectangle_position);
    p.save();
    p.setRasterOp(XorROP);
    p.setPen(QPen(white, 2, SolidLine));
    p.drawRect(rect.normalize());
    p.restore();
}
