// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESNothing.cc,v $
// $Revision: 1.2 $
// $Date: 1999/05/15 22:48:34 $
// $State: Exp $
// **************************************************************

#include "ESNothing.h"
#include "ESDraggingModules.h"
#include "ESDraggingRectangle.h"
#include "ESDraggingLayoutRect.h"
#include "ESWireing.h"
#include "ESOperatingControl.h"
#include "MacroModuleLook.h"
#include "ModuleLook.h"
#include "rectutils.h"
#include "minmaxabs.h"

EditorState *ESNothing::leftButtonPressed(const QMouseEvent *e)
{
    const bool shift = e->state() & ShiftButton;

    DragPosition dp;

    Annotation *anno = mml->findAnnotationAt(e->pos());
    if (anno) {
	mml->removeAnnotation(anno);
	return this;
    }

    ModuleLook *ml = mml->findModuleLookAt(e->pos());
    if (ml) {
	if (!shift) {
	    if (!ml->getModule()->isSelected()) {
		mml->deselectAllModules();
		mml->selectModule(ml);
	    }
	}
	else mml->toggleSelection(ml);
	if (ml->getModule()->isSelected()) return new ESDraggingModules(mml, e->pos());
    }
    else if (NONE != (dp = mouseClickHitsLayoutRect(e->pos())))
	return new ESDraggingLayoutRect(mml, e->pos(), dp);
    else {
	if (!shift) mml->deselectAllModules();
	return new ESDraggingRectangle(mml, e->pos());
    }
    return this; // Stay in state 'Nothing'
}


EditorState *ESNothing::middleButtonPressed(const QMouseEvent *e)
{
    Annotation *anno = mml->findAnnotationAt(e->pos());
    if (anno) mml->annotationBack(anno);
    
    else {
	ModuleLook *ml = mml->findModuleLookAt(e->pos());
	if (ml) mml->popupWireMenu(ml);
    }
    return this;
}


EditorState *ESNothing::rightButtonPressed(const QMouseEvent *e)
{
    ModuleLook *ml = mml->findModuleLookAt(e->pos());
    if (ml && ml->isControl())
	return new ESOperatingControl(mml, e->pos() - ml->pos(), ml);
    else return this;
}


// This function is in an awfull state due to search for a bug.
EditorState *ESNothing::mouseMoved(const QMouseEvent *event)
{ 
    return this; // DEBUGGING

    ModuleLook *ml = mml->findModuleLookAt(event->pos() );
    if (ml) {
	if (!mml->playing || mml->paused) mml->showModuleName(ml->getModule()->getName().c_str());
	    // mml->widget()->setCursor(upArrowCursor);
    }
    else {
	// if (!mml->playing || mml->paused) mml->showModuleName(""); // TODO: only call showModuleName, if it changes!
	DragPosition dragpos = mouseClickHitsLayoutRect(event->pos());
	switch (dragpos) {
	case LEFT: 
	case RIGHT:        mml->widget()->setCursor(sizeHorCursor); break;
	case BOTTOM:
	case TOP:          mml->widget()->setCursor(sizeVerCursor); break;
	case TOP|LEFT:
	case BOTTOM|RIGHT: mml->widget()->setCursor(sizeFDiagCursor); break;
	case TOP|RIGHT:
	case BOTTOM|LEFT:  mml->widget()->setCursor(sizeBDiagCursor); break;
	    // default: mml->widget()->setCursor(arrowCursor);
	}
    }
    return this; 
}


DragPosition ESNothing::mouseClickHitsLayoutRect(const QPoint& pos) const
{
    if (!mml->doesEditLook()) return NONE;
    QRect inner_rect = enlargeRect(mml->layoutRect() * (2 * GRID_SPACING), 1);
    QRect outer_rect = enlargeRect(inner_rect, LAYOUT_RECT_THICKNESS + 1);
    if (outer_rect.contains(pos) && !inner_rect.contains(pos)) 
    {
	unsigned short answer = 0;
	if      (abs((long)(pos.x() - inner_rect.left()))   < 16) answer |= LEFT;
 	else if (abs((long)(pos.x() - inner_rect.right()))  < 16) answer |= RIGHT;
 	if      (abs((long)(pos.y() - inner_rect.top()))    < 16) answer |= TOP;
 	else if (abs((long)(pos.y() - inner_rect.bottom())) < 16) answer |= BOTTOM;
 	return (DragPosition)answer;
    }
    return NONE;
}
