// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/EditorState.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#ifndef EditorState_h
#define EditorState_h

#include <qevent.h>

class MacroModuleLook;

class EditorState
{
protected:
    MacroModuleLook *mml;

public:
    EditorState(MacroModuleLook *mml) : mml(mml) {};
    virtual ~EditorState() {};

    /**
     * Setup this state. This may include painting, refresh commands etc.
     */
    virtual void enter() {};

    /**
     * Prepare for leaving this state. Clean up things.
     */
    virtual void leave() {};

    /**
     * Do any painting that is pecular required to this editor.
     */
    virtual void paintEvent(QPainter&, const QRect& /* update_rect */) {};

    /**
     * Handle an Event. Step in the automaton.
     * @return the new editor state. May be the same as the old one.
     */
    EditorState *handleEvent(const QEvent *e);

protected:
    EditorState *mousePressEvent  (const QMouseEvent *);
    EditorState *mouseReleaseEvent(const QMouseEvent *);
    EditorState *keyPressEvent    (const QKeyEvent *);
    EditorState *mouseMoveEvent   (const QMouseEvent *);

    virtual EditorState *leftButtonPressed   (const QMouseEvent *) { return this; };
    virtual EditorState *leftButtonReleased  (const QMouseEvent *) { return this; };
    virtual EditorState *middleButtonPressed (const QMouseEvent *) { return this; };
    virtual EditorState *middleButtonReleased(const QMouseEvent *) { return this; };
    virtual EditorState *rightButtonPressed  (const QMouseEvent *) { return this; };
    virtual EditorState *rightButtonReleased (const QMouseEvent *) { return this; };
    virtual EditorState *mouseMoved          (const QMouseEvent *) { return this; };
    virtual EditorState *keyPressed          (const QKeyEvent   *) { return this; };
};


#endif // EditorState_h
