// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/LookInfoDialog.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#ifndef LookInfoDialog_h
#define LookInfoDialog_h

#include <qdialog.h>
#include <qlined.h>
#include <qchkbox.h>
#include <kcolorbtn.h>
#include <qfiledlg.h>

#include "LookInfo.h"

class MacroModuleLook;

class LookInfoDialog : public QDialog
{
    Q_OBJECT
    MacroModuleLook *mml;
    const LookInfo& old_look;
    QPixmap         new_pixmap;
    LIPixmap        new_lipixmap;

    KColorButton   *w_backgroundcolor;
    QCheckBox      *w_text_layout;
    QLineEdit      *w_layouttext;
    KColorButton   *w_textcolor;
    QCheckBox      *w_image_layout;
    QPushButton    *w_image_button;
    QCheckBox      *w_separators;
    QCheckBox      *w_threed_borders;
    QCheckBox      *w_rounded_edges;
    QLineEdit      *w_name;
    QLineEdit      *w_description;
    QLabel         *l_name;
    QLabel         *l_description;
    QLabel         *l_text;
    QLabel         *l_textcolor;
    QLabel         *l_image;
    QPushButton    *w_okbutton;
    QPushButton    *w_cancelbutton;
    QLabel         *l_preview;
    
    QFileDialog     filedialog;
public:
    LookInfoDialog(MacroModuleLook *mml, const LookInfo &old_look);
    LookInfo *newLook();

    /**
     * Fill structure new_look with the current values contained
     * in the widgets of the dialog.
     */
    void getNewLook(LookInfo& new_look);

private slots:
    void somethingChanged(const char *);
    void somethingChanged();
    void loadImage();

signals:
    void wantsPreview(QPainter& p, const LookInfo& ml);

protected:
    void resizeEvent(QResizeEvent *);

private:
    /**
     * Initialize the widgets and the image with the old settings.
     */
    void readOldSettings();
};


#endif // LookInfoDialog_h
