// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/MusicdrawTopLevel.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#ifndef MusicdrawTopLevel_h
#define MusicdrawTopLevel_h

#include <qfiledlg.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>

#include "SplashScreen.h"

class MacroModule;
class MacroModuleLook;
class MacroModuleEditor;
class ModuleLookGenerator;
class InputModuleFile;
class OutputModuleFile;
class SplashScreen;

class MusicdrawTopLevel: public KTopLevelWidget
{
    Q_OBJECT;

    KApplication      *application;
    SplashScreen      *splashscreen;
    MacroModuleEditor *main_client_widget; // is 0, when no file is open
    MacroModule       *macro_module;       // MacroModule being edited.
    MacroModuleLook   *macro_module_look;
    QString            filename;           // name of the open file or ""
    KMenuBar          *menubar;
    KToolBar          *toolbar;
    KStatusBar        *statusbar;
    QPopupMenu        *file_menu;
    QPopupMenu        *help_menu;
    int                menuid_insert;       // remembering the indices for enabling
    int 	       menuid_save;         // and disabling the items
    int                menuid_save_as;
    int                menuid_close;
    enum { toolbarid_new = 0,
	   toolbarid_open = 1,
	   toolbarid_save = 2 };
    QFileDialog        *filedialog;         // keeping dialog keeps current dir also
    
public:
    MusicdrawTopLevel( KApplication *application, const char *name=0 );
    ~MusicdrawTopLevel();

    void openFile(const char *fn=0);
    OutputModuleFile *getOutputFile(const char *filename=0);
    InputModuleFile *getInputFile(const char *filename);
    
private:
    void    createMenu();
    void    createToolbar();
    void    checkMenuAndToolbarEnabling();
 
    void    setFilename(const char *);
    void    clearFilename();
    QString askFilename(const char *title);
    void    setNewMainWidget(MacroModuleEditor *);
    bool    removeCurrentMainWidget();
    void    openOrInsert(bool open);
    void    openOrInsert(bool open, QString filename);

    void    closeEvent(QCloseEvent *) { quit(); };;
    void    keyPressEvent(QKeyEvent *);
    
private slots: //
    
    void open() { openOrInsert(true); };
    void neww();                              // new is a keyword :-)
    void insert() { openOrInsert(false); }; 
    void save();
    void saveAs();
    void close();
    void quit();

    void help();
    void about();
    void examples();
};


#endif // MusicdrawTopLevel_h
